/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.security.cert.X509Certificate;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.model.AccessPointIdentifier;
import network.oxalis.api.model.Direction;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.statistics.StatisticsService;
import network.oxalis.api.util.Type;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.statistics.api.ChannelId;
import network.oxalis.statistics.api.RawStatisticsRepository;
import network.oxalis.statistics.model.DefaultRawStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Type(value={"default"})
class DefaultStatisticsService
extends Traceable
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final RawStatisticsRepository rawStatisticsRepository;

    @Inject
    public DefaultStatisticsService(RawStatisticsRepository rawStatisticsRepository, Tracer tracer) {
        super(tracer);
        this.rawStatisticsRepository = rawStatisticsRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(TransmissionRequest transmissionRequest, TransmissionResponse transmissionResponse) {
        Span span = this.tracer.spanBuilder("persist statistics").startSpan();
        try {
            String protocolName = transmissionRequest.getEndpoint().getTransportProfile().getIdentifier();
            String receivingAccessPointCommonName = transmissionRequest.getEndpoint().getCertificate() != null ? CertificateUtils.extractCommonName((X509Certificate)transmissionRequest.getEndpoint().getCertificate()) : "";
            DefaultRawStatistics rawStatistics = ((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)new DefaultRawStatistics.RawStatisticsBuilder().accessPointIdentifier(new AccessPointIdentifier(receivingAccessPointCommonName))).direction(Direction.OUT)).documentType(transmissionResponse.getHeader().getDocumentType())).sender(transmissionResponse.getHeader().getSender()).receiver(transmissionResponse.getHeader().getReceiver()).profile(transmissionResponse.getHeader().getProcess())).channel(new ChannelId(protocolName))).date(transmissionResponse.getTimestamp())).build();
            this.rawStatisticsRepository.persist(rawStatistics);
        }
        catch (Exception ex) {
            span.setAttribute("exception", String.valueOf(ex.getMessage()));
            log.error("Persisting DefaultRawStatistics about outbound transmission failed : {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            span.end();
        }
    }

    public void persist(InboundMetadata inboundMetadata) {
        try {
            String protocolName = inboundMetadata.getProtocol().getIdentifier();
            String sendingAccessPointCommonName = CertificateUtils.extractCommonName((X509Certificate)inboundMetadata.getCertificate());
            DefaultRawStatistics rawStatistics = ((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)new DefaultRawStatistics.RawStatisticsBuilder().accessPointIdentifier(new AccessPointIdentifier(sendingAccessPointCommonName))).direction(Direction.IN)).documentType(inboundMetadata.getHeader().getDocumentType())).sender(inboundMetadata.getHeader().getSender()).receiver(inboundMetadata.getHeader().getReceiver()).profile(inboundMetadata.getHeader().getProcess())).channel(new ChannelId(protocolName))).build();
            this.rawStatisticsRepository.persist(rawStatistics);
        }
        catch (Exception e) {
            log.error("Unable to persist statistics for " + inboundMetadata.toString() + ";\n " + e.getMessage(), (Throwable)e);
        }
    }
}

