/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.jdbc;

import jakarta.inject.Inject;
import network.oxalis.persistence.annotation.Repository;
import network.oxalis.persistence.api.JdbcTxManager;
import network.oxalis.statistics.api.StatisticsGranularity;
import network.oxalis.statistics.jdbc.RawStatisticsRepositoryJdbcImpl;

@Repository
public class RawStatisticsRepositoryMySqlImpl
extends RawStatisticsRepositoryJdbcImpl {
    @Inject
    public RawStatisticsRepositoryMySqlImpl(JdbcTxManager jdbcTxManager) {
        super(jdbcTxManager);
    }

    @Override
    String getPersistSqlQueryText() {
        return String.format("INSERT INTO %s (ap, tstamp,  direction, sender, receiver, doc_type, profile, channel) values(?,?,?,?,?,?,?,?)", "raw_stats");
    }

    @Override
    String getRawStatisticsSqlQueryText(StatisticsGranularity granularity) {
        String mySqlDateFormat = RawStatisticsRepositoryMySqlImpl.mySqlDateFormat(granularity);
        return "SELECT\n  ap,\n  'OUT' direction,\n  date_format(tstamp,'" + mySqlDateFormat + "') period,\n  sender ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'OUT'\n  and tstamp between ? and ?\nGROUP BY 1,2,3,4,5,6,7\nunion\nSELECT\n  ap,\n  'IN' direction,\n  date_format(tstamp,'" + mySqlDateFormat + "') period,\n  receiver ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'IN'\n  and tstamp between ? and ?\n\nGROUP BY 1,2,3,4,5,6,7\norder by period, ap\n;";
    }

    static String mySqlDateFormat(StatisticsGranularity granularity) {
        switch (granularity) {
            case YEAR: {
                return "%Y";
            }
            case MONTH: {
                return "%Y-%m";
            }
            case DAY: {
                return "%Y-%m-%d";
            }
            case HOUR: {
                return "%Y-%m-%dT%h";
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert '%s' into a MySQL date_format() string.", new Object[]{granularity}));
    }
}

