/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.test.asd;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.outbound.MessageSender;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.test.asd.AsdTransmissionResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;

@Singleton
public class AsdMessageSender
implements MessageSender {
    @Inject
    private CloseableHttpClient httpClient;
    @Inject
    private Config config;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransmissionResponse send(TransmissionRequest transmissionRequest) throws OxalisTransmissionException {
        TransmissionIdentifier transmissionIdentifier = TransmissionIdentifier.generateUUID();
        if (this.config.hasPath("oxalis.asd.sender.skip") && this.config.getBoolean("oxalis.asd.sender.skip")) {
            return new AsdTransmissionResponse(transmissionRequest, transmissionIdentifier);
        }
        HttpPost httpPost = new HttpPost(transmissionRequest.getEndpoint().getAddress());
        httpPost.setHeader("X-ASD-TransmissionID", transmissionIdentifier.getIdentifier());
        httpPost.setEntity((HttpEntity)new InputStreamEntity(transmissionRequest.getPayload()));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String status = response.getFirstHeader("X-ASD-Status").getValue();
            if (!"OK".equals(status)) {
                throw new OxalisTransmissionException(status);
            }
            AsdTransmissionResponse asdTransmissionResponse = new AsdTransmissionResponse(transmissionRequest, transmissionIdentifier);
            return asdTransmissionResponse;
        }
        catch (OxalisTransmissionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OxalisTransmissionException("Unable to send message.", (Throwable)e);
        }
    }
}

