/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.test.asd;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.lang.TimestampException;
import network.oxalis.api.model.Direction;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.persist.PersisterHandler;
import network.oxalis.api.timestamp.Timestamp;
import network.oxalis.api.timestamp.TimestampProvider;
import network.oxalis.test.asd.AsdInboundMetadata;
import network.oxalis.vefa.peppol.common.model.Header;

@Singleton
public class AsdServlet
extends HttpServlet {
    @Inject
    private Provider<PersisterHandler> persisterHandlerProvider;
    @Inject
    private TimestampProvider timestampProvider;
    @Inject
    private HeaderParser headerParser;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.getWriter().write("Hello ASD world!");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PersisterHandler persisterHandler = (PersisterHandler)this.persisterHandlerProvider.get();
        TransmissionIdentifier transmissionIdentifier = null;
        Header header = null;
        Path path = null;
        try {
            Timestamp timestamp = this.timestampProvider.generate(null, Direction.IN);
            byte[] content = ByteStreams.toByteArray((InputStream)req.getInputStream());
            transmissionIdentifier = TransmissionIdentifier.of((String)req.getHeader("X-ASD-TransmissionID"));
            header = this.headerParser.parse((InputStream)new ByteArrayInputStream(content));
            path = persisterHandler.persist(transmissionIdentifier, header, (InputStream)new ByteArrayInputStream(content));
            persisterHandler.persist((InboundMetadata)new AsdInboundMetadata(transmissionIdentifier, header, timestamp.getDate()), path);
            resp.setStatus(200);
            resp.setHeader("X-ASD-Status", "OK");
            resp.setHeader("X-ASD-Timestamp", timestamp.getDate().toString());
        }
        catch (OxalisContentException | TimestampException e) {
            persisterHandler.persist(transmissionIdentifier, header, path, (Exception)e);
            resp.setStatus(400);
            resp.setHeader("X-ASD-Status", String.format("ERROR: %s", e.getMessage()));
        }
    }
}

