/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.test.jetty;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractJettyServerTest {
    protected Injector injector;
    protected Server server;

    public abstract Injector getInjector();

    @BeforeClass
    public void beforeClass() throws Exception {
        this.injector = this.getInjector();
        this.server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, "/");
        handler.addFilter(GuiceFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        handler.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return AbstractJettyServerTest.this.injector;
            }
        });
        handler.addServlet(DefaultServlet.class, "/");
        this.server.start();
    }

    @AfterClass
    public void afterClass() throws Exception {
        this.server.stop();
    }
}

