/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.regex.Pattern;
import network.oxalis.vefa.peppol.common.lang.PeppolException;
import network.oxalis.vefa.peppol.common.model.AbstractSimpleIdentifier;

public class TransportProtocol
extends AbstractSimpleIdentifier
implements Serializable {
    private static final long serialVersionUID = -5938766453542971103L;
    private static Pattern pattern = Pattern.compile("[\\p{Upper}\\d]+");
    public static final TransportProtocol AS2 = new TransportProtocol("AS2");
    public static final TransportProtocol AS4 = new TransportProtocol("AS4");
    public static final TransportProtocol INTERNAL = new TransportProtocol("INTERNAL");

    public static TransportProtocol of(String value) throws PeppolException {
        if (!pattern.matcher(value).matches()) {
            throw new PeppolException("Identifier not according to pattern.");
        }
        return new TransportProtocol(value);
    }

    private TransportProtocol(String identifier) {
        super(identifier);
    }

    @Override
    public String toString() {
        return "TransportProtocol{" + this.value + "}";
    }
}

