/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import network.oxalis.vefa.peppol.common.model.AbstractQualifiedIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;

public class MlsToIdentifier
extends AbstractQualifiedIdentifier
implements Serializable {
    private static final long serialVersionUID = 2384671903287416598L;
    public static final Scheme DEFAULT_SCHEME = Scheme.of("iso6523-actorid-upis");

    public static MlsToIdentifier of(String value) {
        return MlsToIdentifier.of(value, DEFAULT_SCHEME);
    }

    public static MlsToIdentifier of(String value, Scheme scheme) {
        return new MlsToIdentifier(value, scheme);
    }

    private MlsToIdentifier(String identifier, Scheme scheme) {
        super(identifier.trim().toLowerCase(Locale.US), scheme);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlsToIdentifier that = (MlsToIdentifier)o;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.scheme.equals(that.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.identifier);
    }

    public String toString() {
        return String.valueOf(this.scheme) + "::" + this.identifier;
    }
}

