/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup;

import java.io.FileNotFoundException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import network.oxalis.vefa.peppol.common.api.PotentiallySigned;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.Redirect;
import network.oxalis.vefa.peppol.common.model.ServiceInformation;
import network.oxalis.vefa.peppol.common.model.ServiceMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.common.model.Signed;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.lookup.LookupClientBuilder;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.MetadataFetcher;
import network.oxalis.vefa.peppol.lookup.api.MetadataLocator;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;
import network.oxalis.vefa.peppol.lookup.api.MetadataReader;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

public class LookupClient {
    private final MetadataLocator locator;
    private final MetadataProvider provider;
    private final MetadataFetcher fetcher;
    private final MetadataReader reader;
    private final CertificateValidator validator;

    protected LookupClient(LookupClientBuilder builder) {
        this.locator = builder.metadataLocator;
        this.provider = builder.metadataProvider;
        this.fetcher = builder.metadataFetcher;
        this.reader = builder.metadataReader;
        this.validator = builder.certificateValidator;
    }

    public List<ServiceReference> getServiceReferences(ParticipantIdentifier participantIdentifier) throws LookupException {
        FetcherResponse fetcherResponse;
        URI location = this.locator.lookup(participantIdentifier);
        URI serviceReferencesUri = this.provider.resolveDocumentIdentifiers(location, participantIdentifier);
        try {
            fetcherResponse = this.fetcher.fetch(serviceReferencesUri);
        }
        catch (FileNotFoundException e) {
            throw new LookupException(String.format("Receiver (%s) not found.", participantIdentifier.toString()), e);
        }
        return this.reader.parseServiceGroup(fetcherResponse);
    }

    public List<DocumentTypeIdentifier> getDocumentIdentifiers(ParticipantIdentifier participantIdentifier) throws LookupException {
        return this.getServiceReferences(participantIdentifier).stream().map(ServiceReference::getDocumentTypeIdentifier).collect(Collectors.toList());
    }

    public ServiceMetadata getServiceMetadata(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier) throws LookupException, PeppolSecurityException {
        ServiceMetadata serviceMetadata;
        URI location = this.locator.lookup(participantIdentifier);
        URI serviceMetaDataUri = this.provider.resolveServiceMetadata(location, participantIdentifier, documentTypeIdentifier);
        PotentiallySigned<ServiceMetadata> potentiallySigned = this.getPotentiallySignedMetadata(participantIdentifier, documentTypeIdentifier, serviceMetaDataUri);
        if (potentiallySigned instanceof Signed) {
            this.validator.validate(Service.SMP, ((Signed)potentiallySigned).getCertificate());
        }
        if ((serviceMetadata = (ServiceMetadata)potentiallySigned.getContent()).getServiceInformation() != null) {
            return serviceMetadata;
        }
        Redirect redirect = serviceMetadata.getRedirect();
        if (redirect != null) {
            return this.handleRedirect(participantIdentifier, documentTypeIdentifier, redirect);
        }
        throw new LookupException(String.format("Combination of receiver (%s) and document type identifier (%s) is not supported.", participantIdentifier.toString(), documentTypeIdentifier.toString()));
    }

    private ServiceMetadata handleRedirect(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, Redirect redirect) throws LookupException, PeppolSecurityException {
        ServiceMetadata serviceMetadata;
        PotentiallySigned<ServiceMetadata> potentiallySigned = this.getPotentiallySignedMetadata(participantIdentifier, documentTypeIdentifier, URI.create(redirect.getHref()));
        if (potentiallySigned instanceof Signed) {
            X509Certificate certificate = ((Signed)potentiallySigned).getCertificate();
            this.validator.validate(Service.SMP, certificate);
            if (!certificate.getSubjectX500Principal().getName().equals(redirect.getCertificateUID())) {
                throw new LookupException(String.format("Subject of redirected response for receiver (%s) and document type identifier (%s) does not match the expected value. Actual: '%s', Expected: '%s'", participantIdentifier.toString(), documentTypeIdentifier.toString(), certificate.getSubjectX500Principal().getName(), redirect.getCertificateUID()));
            }
        }
        if ((serviceMetadata = (ServiceMetadata)potentiallySigned.getContent()).getServiceInformation() != null) {
            return serviceMetadata;
        }
        throw new LookupException(String.format("Redirect failed for receiver (%s) and document type identifier (%s) is not supported.", participantIdentifier.toString(), documentTypeIdentifier.toString()));
    }

    private PotentiallySigned<ServiceMetadata> getPotentiallySignedMetadata(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, URI serviceMetaDataUri) throws LookupException, PeppolSecurityException {
        try {
            FetcherResponse fetcherResponse = this.fetcher.fetch(serviceMetaDataUri);
            return this.reader.parseServiceMetadata(fetcherResponse);
        }
        catch (FileNotFoundException e) {
            throw new LookupException(String.format("Combination of receiver (%s) and document type identifier (%s) is not supported.", participantIdentifier.toString(), documentTypeIdentifier.toString()), e);
        }
    }

    public Endpoint getEndpoint(ServiceMetadata serviceMetadata, ProcessIdentifier processIdentifier, TransportProfile ... transportProfiles) throws PeppolSecurityException, EndpointNotFoundException {
        ServiceInformation serviceInformation = serviceMetadata.getServiceInformation();
        if (serviceInformation != null) {
            Endpoint endpoint = (Endpoint)serviceInformation.getEndpoint(processIdentifier, transportProfiles);
            this.validator.validate(Service.AP, endpoint.getCertificate());
            return endpoint;
        }
        throw new EndpointNotFoundException(String.format("Combination of '%s' and transport profile(s) not found.", processIdentifier));
    }

    public Endpoint getEndpoint(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, ProcessIdentifier processIdentifier, TransportProfile ... transportProfiles) throws LookupException, PeppolSecurityException, EndpointNotFoundException {
        ServiceMetadata serviceMetadata = this.getServiceMetadata(participantIdentifier, documentTypeIdentifier);
        return this.getEndpoint(serviceMetadata, processIdentifier, transportProfiles);
    }

    public Endpoint getEndpoint(Header header, TransportProfile ... transportProfiles) throws LookupException, PeppolSecurityException, EndpointNotFoundException {
        return this.getEndpoint(header.getReceiver(), header.getDocumentType(), header.getProcess(), transportProfiles);
    }
}

