/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.util.ModelUtils;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;

public class DefaultProvider
implements MetadataProvider {
    public static final int SEPARATOR_LENGTH = 2;
    public static final String WILDCARD_INDICATOR_CHARACTER = "*";
    public static final String NARROWER_SCHEMEPART_INDICATOR_CHARACTER = "@";
    public static final String PINT_TEXT = "urn:peppol:pint:";
    List<URI> resolvedServiceMetaDataURIList;

    @Override
    public List<URI> resolveDocumentIdentifiers(URI location, ParticipantIdentifier participant) {
        ArrayList<URI> resolvedDocumentIdentifiersURIList = new ArrayList<URI>();
        resolvedDocumentIdentifiersURIList.add(location.resolve(String.format("/%s", participant.urlencoded())));
        return resolvedDocumentIdentifiersURIList;
    }

    @Override
    public List<URI> resolveServiceMetadata(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, int pintWildcardMigrationPhase) {
        this.resolvedServiceMetaDataURIList = new ArrayList<URI>();
        String documentTypeSchemeIdentifier = documentTypeIdentifier.getScheme().getIdentifier();
        if (documentTypeSchemeIdentifier.equals("busdox-docid-qns") && !this.isItPINTMessage(documentTypeIdentifier)) {
            this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
        } else if (this.isItPINTMessage(documentTypeIdentifier)) {
            this.resolvePintExactMatchPriorityBasedOnPhase(location, participantIdentifier, documentTypeIdentifier, pintWildcardMigrationPhase);
            if (documentTypeSchemeIdentifier.equals("peppol-doctype-wildcard")) {
                String instanceIdentifier = documentTypeIdentifier.getIdentifier();
                int customizationValueStartIndex = instanceIdentifier.indexOf("##") + 2;
                int customizationValueEndIndex = instanceIdentifier.lastIndexOf("::");
                String syntaxSpecificId = instanceIdentifier.substring(0, customizationValueStartIndex - 2);
                String customizationIdentifier = instanceIdentifier.substring(customizationValueStartIndex, customizationValueEndIndex);
                String version = instanceIdentifier.substring(customizationValueEndIndex + 2);
                String customizationIdentifierWithWildCardCharacter = customizationIdentifier + WILDCARD_INDICATOR_CHARACTER;
                String resolvedPeppolWildCardDocTypeDocumentIdentifierUrlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{documentTypeSchemeIdentifier, syntaxSpecificId, customizationIdentifierWithWildCardCharacter, version});
                this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), resolvedPeppolWildCardDocTypeDocumentIdentifierUrlEncoded)));
                while (customizationIdentifier.contains(NARROWER_SCHEMEPART_INDICATOR_CHARACTER)) {
                    String trimmedCustomizationIdentifier = customizationIdentifier.substring(0, customizationIdentifier.lastIndexOf(NARROWER_SCHEMEPART_INDICATOR_CHARACTER));
                    String trimmedCustomizationIdentifierWithWildCardCharacter = trimmedCustomizationIdentifier + WILDCARD_INDICATOR_CHARACTER;
                    String trimmedResolvedDocumentIdentifierUrlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{documentTypeSchemeIdentifier, syntaxSpecificId, trimmedCustomizationIdentifierWithWildCardCharacter, version});
                    this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), trimmedResolvedDocumentIdentifierUrlEncoded)));
                    customizationIdentifier = trimmedCustomizationIdentifier;
                }
            }
        }
        return this.resolvedServiceMetaDataURIList;
    }

    private boolean isItPINTMessage(DocumentTypeIdentifier documentTypeIdentifier) {
        String customizationIdentifier = this.getCustomizationIdentifier(documentTypeIdentifier);
        return this.isPintTextExistInCustomization(customizationIdentifier) == 1;
    }

    private String getCustomizationIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        String instanceIdentifier = documentTypeIdentifier.getIdentifier();
        int customizationValueStartIndex = instanceIdentifier.indexOf("##") + 2;
        int customizationValueEndIndex = instanceIdentifier.lastIndexOf("::");
        return instanceIdentifier.substring(customizationValueStartIndex, customizationValueEndIndex);
    }

    private int isPintTextExistInCustomization(String customizationIdentifier) {
        String customizationIdentifierLowerCase = customizationIdentifier.toLowerCase();
        if (customizationIdentifierLowerCase.contains(PINT_TEXT)) {
            return 1;
        }
        return -1;
    }

    private List<URI> resolvePintExactMatchPriorityBasedOnPhase(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, int pintWildcardMigrationPhase) {
        String documentTypeSchemeIdentifier = documentTypeIdentifier.getScheme().getIdentifier();
        if (pintWildcardMigrationPhase == 0 && documentTypeSchemeIdentifier.equals("busdox-docid-qns")) {
            this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
        }
        if (pintWildcardMigrationPhase == 1) {
            if (documentTypeSchemeIdentifier.equals("peppol-doctype-wildcard") || documentTypeSchemeIdentifier.equals("busdox-docid-qns")) {
                this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
            }
        } else if (pintWildcardMigrationPhase >= 2 && documentTypeSchemeIdentifier.equals("peppol-doctype-wildcard")) {
            this.resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
        }
        return this.resolvedServiceMetaDataURIList;
    }
}

