/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.util.ModelUtils;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;
import org.apache.commons.lang3.StringUtils;

public class DefaultProvider
implements MetadataProvider {
    private static final int SEPARATOR_LENGTH = 2;
    private static final String WILDCARD_INDICATOR_CHARACTER = "*";
    private static final String NARROWER_SCHEMEPART_INDICATOR_CHARACTER = "@";
    private static final String PINT_TEXT = "urn:peppol:pint:";

    @Override
    public List<URI> resolveDocumentIdentifiers(URI location, ParticipantIdentifier participantIdentifier) {
        String basePath = this.normalizeBasePath(location.toString());
        URI baseUri = URI.create(basePath + "/");
        URI resolvedUri = baseUri.resolve(participantIdentifier.urlencoded());
        return List.of(resolvedUri);
    }

    @Override
    public List<URI> resolveServiceMetadata(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier) {
        ArrayList<URI> resolvedServiceMetaDataURIList = new ArrayList<URI>();
        String docSchemeIdentifier = documentTypeIdentifier.getScheme().getIdentifier();
        boolean isPintMessage = this.isItPINTMessage(documentTypeIdentifier);
        if ("busdox-docid-qns".equals(docSchemeIdentifier) && !isPintMessage) {
            this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
        } else if (isPintMessage) {
            this.resolvePintExactMatchPriority(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
            if ("peppol-doctype-wildcard".equals(docSchemeIdentifier)) {
                this.processPintWildcards(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
            }
        }
        return resolvedServiceMetaDataURIList;
    }

    private boolean isItPINTMessage(DocumentTypeIdentifier documentTypeIdentifier) {
        String customizationId = this.getCustomizationIdentifier(documentTypeIdentifier);
        return customizationId.contains(PINT_TEXT);
    }

    private String getCustomizationIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        String instanceId = documentTypeIdentifier.getIdentifier();
        int startIdx = instanceId.indexOf("##");
        int endIdx = instanceId.lastIndexOf("::");
        if (startIdx == -1 || endIdx == -1 || startIdx + 2 >= endIdx) {
            throw new IllegalArgumentException(String.format("Unable to parse '%s' into Peppol Document Type Identifier", instanceId));
        }
        return instanceId.substring(startIdx + 2, endIdx);
    }

    private void resolvePintExactMatchPriority(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<URI> resolvedServiceMetaDataURIList) {
        this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
    }

    private void processPintWildcards(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<URI> resolvedServiceMetaDataURIList) {
        String instanceId = documentTypeIdentifier.getIdentifier();
        int startIdx = instanceId.indexOf("##");
        int endIdx = instanceId.lastIndexOf("::");
        if (startIdx == -1 || endIdx == -1 || startIdx + 2 >= endIdx) {
            return;
        }
        String syntaxId = instanceId.substring(0, startIdx);
        String customizationId = instanceId.substring(startIdx + 2, endIdx);
        String version = "";
        if (endIdx + 2 <= instanceId.length()) {
            version = instanceId.substring(endIdx + 2);
        }
        this.addWildcardUris(location, participantIdentifier, documentTypeIdentifier.getScheme().getIdentifier(), syntaxId, customizationId, version, resolvedServiceMetaDataURIList);
    }

    private void addWildcardUris(URI location, ParticipantIdentifier participantIdentifier, String docScheme, String syntaxId, String customizationId, String version, List<URI> resolvedServiceMetaDataURIList) {
        if (StringUtils.isBlank((CharSequence)customizationId)) {
            return;
        }
        String currentCustomizationId = customizationId;
        while (!currentCustomizationId.isEmpty()) {
            String documentTypeIdentifierUrlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{docScheme, syntaxId, currentCustomizationId + WILDCARD_INDICATOR_CHARACTER, version});
            this.addResolvedServiceURI(location, participantIdentifier, documentTypeIdentifierUrlEncoded, resolvedServiceMetaDataURIList);
            int lastIdx = currentCustomizationId.lastIndexOf(NARROWER_SCHEMEPART_INDICATOR_CHARACTER);
            if (lastIdx == -1) break;
            currentCustomizationId = currentCustomizationId.substring(0, lastIdx);
        }
    }

    private void addResolvedUri(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<URI> resolvedServiceMetaDataURIList) {
        this.addResolvedServiceURI(location, participantIdentifier, documentTypeIdentifier.urlencoded(), resolvedServiceMetaDataURIList);
    }

    private void addResolvedServiceURI(URI location, ParticipantIdentifier participantIdentifier, String documentTypeIdentifierUrlEncoded, List<URI> resolvedServiceMetaDataURIList) {
        String basePath = this.normalizeBasePath(location.toString());
        URI baseUri = URI.create(basePath + "/");
        URI resolvedUri = baseUri.resolve(String.format("%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifierUrlEncoded));
        resolvedServiceMetaDataURIList.add(resolvedUri);
    }

    private String normalizeBasePath(String location) {
        String basePath = location.trim();
        while (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }
}

