/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.builder;

import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.api.SimpleEndpoint;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.publisher.model.PublisherEndpoint;
import network.oxalis.vefa.peppol.publisher.model.PublisherServiceMetadata;

public class ServiceMetadataBuilder {
    private ParticipantIdentifier participantIdentifier;
    private DocumentTypeIdentifier documentTypeIdentifier;
    private List<ProcessMetadata<PublisherEndpoint>> processes = new ArrayList<ProcessMetadata<PublisherEndpoint>>();

    public static ServiceMetadataBuilder newInstance() {
        return new ServiceMetadataBuilder();
    }

    private ServiceMetadataBuilder() {
    }

    public ServiceMetadataBuilder participant(ParticipantIdentifier participantIdentifier) {
        this.participantIdentifier = participantIdentifier;
        return this;
    }

    public ServiceMetadataBuilder documentTypeIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        this.documentTypeIdentifier = documentTypeIdentifier;
        return this;
    }

    public ServiceMetadataBuilder add(ProcessIdentifier processIdentifier, PublisherEndpoint ... endpoints) {
        this.processes.add((ProcessMetadata<PublisherEndpoint>)ProcessMetadata.of((ProcessIdentifier)processIdentifier, (SimpleEndpoint[])endpoints));
        return this;
    }

    public PublisherServiceMetadata build() {
        return new PublisherServiceMetadata(this.participantIdentifier, this.documentTypeIdentifier, this.processes);
    }
}

