/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.syntax;

import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.publisher.annotation.Syntax;
import network.oxalis.vefa.peppol.publisher.model.PublisherEndpoint;
import network.oxalis.vefa.peppol.publisher.model.PublisherServiceMetadata;
import network.oxalis.vefa.peppol.publisher.model.ServiceGroup;
import network.oxalis.vefa.peppol.publisher.syntax.AbstractPublisherSyntax;
import no.difi.commons.busdox.jaxb.addressing.AttributedURIType;
import no.difi.commons.busdox.jaxb.addressing.EndpointReferenceType;
import no.difi.commons.busdox.jaxb.addressing.MetadataType;
import no.difi.commons.busdox.jaxb.addressing.ReferenceParametersType;
import no.difi.commons.busdox.jaxb.identifiers.DocumentIdentifierType;
import no.difi.commons.busdox.jaxb.identifiers.ParticipantIdentifierType;
import no.difi.commons.busdox.jaxb.identifiers.ProcessIdentifierType;
import no.difi.commons.busdox.jaxb.smp.EndpointType;
import no.difi.commons.busdox.jaxb.smp.ObjectFactory;
import no.difi.commons.busdox.jaxb.smp.ProcessListType;
import no.difi.commons.busdox.jaxb.smp.ProcessType;
import no.difi.commons.busdox.jaxb.smp.ServiceEndpointList;
import no.difi.commons.busdox.jaxb.smp.ServiceGroupType;
import no.difi.commons.busdox.jaxb.smp.ServiceInformationType;
import no.difi.commons.busdox.jaxb.smp.ServiceMetadataReferenceCollectionType;
import no.difi.commons.busdox.jaxb.smp.ServiceMetadataReferenceType;
import no.difi.commons.busdox.jaxb.smp.ServiceMetadataType;
import no.difi.commons.busdox.jaxb.smp.SignedServiceMetadataType;

@Syntax(value={"busdox"})
public class BusdoxPublisherSyntax
extends AbstractPublisherSyntax {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final JAXBContext JAXB_CONTEXT = (JAXBContext)ExceptionUtil.perform(IllegalStateException.class, () -> JAXBContext.newInstance((Class[])new Class[]{ServiceGroupType.class, ServiceMetadataType.class, SignedServiceMetadataType.class}));
    private static final BaseEncoding BASE64 = BaseEncoding.base64().withSeparator("\n", 76);

    @Override
    public JAXBElement<?> of(ServiceGroup serviceGroup, URI rootUri) {
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier(this.convert(serviceGroup.getParticipantIdentifier()));
        serviceGroupType.setServiceMetadataReferenceCollection(new ServiceMetadataReferenceCollectionType());
        for (ServiceReference serviceReference : serviceGroup.getServiceReferences()) {
            serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference().add(this.convertRef(serviceGroup.getParticipantIdentifier(), serviceReference.getDocumentTypeIdentifier(), rootUri));
        }
        return OBJECT_FACTORY.createServiceGroup(serviceGroupType);
    }

    @Override
    public JAXBElement<?> of(PublisherServiceMetadata serviceMetadata, boolean forSigning) {
        ServiceInformationType serviceInformationType = new ServiceInformationType();
        serviceInformationType.setParticipantIdentifier(this.convert(serviceMetadata.getParticipantIdentifier()));
        serviceInformationType.setDocumentIdentifier(this.convert(serviceMetadata.getDocumentTypeIdentifier()));
        serviceInformationType.setProcessList(new ProcessListType());
        for (ProcessMetadata processMetadata : serviceMetadata.getProcesses()) {
            serviceInformationType.getProcessList().getProcess().addAll(this.convert((ProcessMetadata<PublisherEndpoint>)processMetadata));
        }
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        if (forSigning) {
            SignedServiceMetadataType signedServiceMetadataType = new SignedServiceMetadataType();
            signedServiceMetadataType.setServiceMetadata(serviceMetadataType);
            return OBJECT_FACTORY.createSignedServiceMetadata(signedServiceMetadataType);
        }
        return OBJECT_FACTORY.createServiceMetadata(serviceMetadataType);
    }

    @Override
    public Marshaller getMarshaller() throws JAXBException {
        return JAXB_CONTEXT.createMarshaller();
    }

    private ParticipantIdentifierType convert(ParticipantIdentifier participantIdentifier) {
        ParticipantIdentifierType participantIdentifierType = new ParticipantIdentifierType();
        participantIdentifierType.setScheme(participantIdentifier.getScheme().getIdentifier());
        participantIdentifierType.setValue(participantIdentifier.getIdentifier());
        return participantIdentifierType;
    }

    private ProcessIdentifierType convert(ProcessIdentifier processIdentifier) {
        ProcessIdentifierType processIdentifierType = new ProcessIdentifierType();
        processIdentifierType.setScheme(processIdentifier.getScheme().getIdentifier());
        processIdentifierType.setValue(processIdentifier.getIdentifier());
        return processIdentifierType;
    }

    private DocumentIdentifierType convert(DocumentTypeIdentifier documentTypeIdentifier) {
        DocumentIdentifierType documentIdentifierType = new DocumentIdentifierType();
        documentIdentifierType.setScheme(documentTypeIdentifier.getScheme().getIdentifier());
        documentIdentifierType.setValue(documentTypeIdentifier.getIdentifier());
        return documentIdentifierType;
    }

    private List<ProcessType> convert(ProcessMetadata<PublisherEndpoint> processMetadata) {
        ArrayList<ProcessType> result = new ArrayList<ProcessType>();
        for (ProcessIdentifier processIdentifier : processMetadata.getProcessIdentifier()) {
            ProcessType processType = new ProcessType();
            processType.setProcessIdentifier(this.convert(processIdentifier));
            processType.setServiceEndpointList(new ServiceEndpointList());
            for (PublisherEndpoint endpoint : processMetadata.getEndpoints()) {
                processType.getServiceEndpointList().getEndpoint().add(this.convert(endpoint));
            }
            result.add(processType);
        }
        return result;
    }

    private EndpointType convert(PublisherEndpoint endpoint) {
        AttributedURIType attributedURIType = new AttributedURIType();
        attributedURIType.setValue(endpoint.getAddress().toString());
        EndpointReferenceType endpointReferenceType = new EndpointReferenceType();
        endpointReferenceType.setAddress(attributedURIType);
        endpointReferenceType.setMetadata(new MetadataType());
        endpointReferenceType.setReferenceParameters(new ReferenceParametersType());
        EndpointType endpointType = new EndpointType();
        endpointType.setTransportProfile(endpoint.getTransportProfile().getIdentifier());
        endpointType.setEndpointReference(endpointReferenceType);
        endpointType.setRequireBusinessLevelSignature(false);
        if (endpoint.getPeriod() != null) {
            endpointType.setServiceActivationDate(this.convert(endpoint.getPeriod().getFrom()));
            endpointType.setServiceExpirationDate(this.convert(endpoint.getPeriod().getTo()));
        }
        endpointType.setCertificate(BASE64.encode(endpoint.getCertificate()));
        endpointType.setServiceDescription(endpoint.getDescription());
        endpointType.setTechnicalContactUrl(endpoint.getTechnicalContact());
        return endpointType;
    }

    private ServiceMetadataReferenceType convertRef(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, URI rootURI) {
        URI uri = rootURI.resolve(String.format("%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded()));
        ServiceMetadataReferenceType serviceMetadataReferenceType = new ServiceMetadataReferenceType();
        serviceMetadataReferenceType.setHref(uri.toString());
        return serviceMetadataReferenceType;
    }
}

