/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import network.oxalis.vefa.peppol.publisher.annotation.Syntax;
import network.oxalis.vefa.peppol.publisher.api.PublisherSyntax;

public class PublisherSyntaxProvider {
    private Map<String, PublisherSyntax> syntaxMap = new HashMap<String, PublisherSyntax>();
    private String defaultSyntax;

    public PublisherSyntaxProvider(String defaultSyntax) {
        this(defaultSyntax, Lists.newArrayList(ServiceLoader.load(PublisherSyntax.class).iterator()));
        for (PublisherSyntax syntax : ServiceLoader.load(PublisherSyntax.class)) {
            for (String syntaxKey : syntax.getClass().getAnnotation(Syntax.class).value()) {
                this.syntaxMap.put(syntaxKey, syntax);
            }
        }
    }

    public PublisherSyntaxProvider(String defaultSyntax, List<PublisherSyntax> publisherSyntaxes) {
        this.defaultSyntax = defaultSyntax;
        for (PublisherSyntax syntax : publisherSyntaxes) {
            for (String syntaxKey : syntax.getClass().getAnnotation(Syntax.class).value()) {
                this.syntaxMap.put(syntaxKey, syntax);
            }
        }
    }

    protected PublisherSyntax getSyntax(String syntax) {
        if (syntax != null && this.syntaxMap.containsKey(syntax)) {
            return this.syntaxMap.get(syntax);
        }
        return this.syntaxMap.get(this.defaultSyntax);
    }
}

