/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.builder;

import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import network.oxalis.vefa.peppol.common.model.Period;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.publisher.model.PublisherEndpoint;

public class EndpointBuilder {
    private TransportProfile transportProfile;
    private URI address;
    private byte[] certificate;
    private Date activationDate;
    private Date expirationDate;
    private String description;
    private String technicalContact;

    public static EndpointBuilder newInstance() {
        return new EndpointBuilder();
    }

    public EndpointBuilder transportProfile(TransportProfile transportProfile) {
        this.transportProfile = transportProfile;
        return this;
    }

    public EndpointBuilder address(URI address) {
        this.address = address;
        return this;
    }

    public EndpointBuilder certificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    public EndpointBuilder certificate(X509Certificate certificate) throws CertificateEncodingException {
        return this.certificate(certificate.getEncoded()).activationDate(certificate.getNotBefore()).expirationDate(certificate.getNotAfter());
    }

    public EndpointBuilder activationDate(Date activationDate) {
        this.activationDate = activationDate;
        return this;
    }

    public EndpointBuilder expirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public EndpointBuilder description(String description) {
        this.description = description;
        return this;
    }

    public EndpointBuilder technicalContact(String technicalContact) {
        this.technicalContact = technicalContact;
        return this;
    }

    public PublisherEndpoint build() {
        Period period = null;
        if (this.activationDate != null || this.expirationDate != null) {
            period = Period.of((Date)this.activationDate, (Date)this.expirationDate);
        }
        return new PublisherEndpoint(this.transportProfile, this.address, this.certificate, period, this.description, this.technicalContact);
    }
}

