/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.syntax;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.Redirect;
import network.oxalis.vefa.peppol.common.model.ServiceInformation;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.publisher.annotation.Syntax;
import network.oxalis.vefa.peppol.publisher.model.PublisherEndpoint;
import network.oxalis.vefa.peppol.publisher.model.PublisherServiceMetadata;
import network.oxalis.vefa.peppol.publisher.model.ServiceGroup;
import network.oxalis.vefa.peppol.publisher.syntax.AbstractPublisherSyntax;
import no.difi.commons.bdx.jaxb.smp._2016._05.DocumentIdentifierType;
import no.difi.commons.bdx.jaxb.smp._2016._05.EndpointType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ObjectFactory;
import no.difi.commons.bdx.jaxb.smp._2016._05.ParticipantIdentifierType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ProcessIdentifierType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ProcessListType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ProcessType;
import no.difi.commons.bdx.jaxb.smp._2016._05.RedirectType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceEndpointList;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceGroupType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceInformationType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceMetadataReferenceCollectionType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceMetadataReferenceType;
import no.difi.commons.bdx.jaxb.smp._2016._05.ServiceMetadataType;
import no.difi.commons.bdx.jaxb.smp._2016._05.SignedServiceMetadataType;

@Syntax(value={"bdxr", "bdxr-201605"})
public class Bdxr201605PublisherSyntax
extends AbstractPublisherSyntax {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final JAXBContext JAXB_CONTEXT = (JAXBContext)ExceptionUtil.perform(IllegalStateException.class, () -> JAXBContext.newInstance((Class[])new Class[]{ServiceGroupType.class, ServiceMetadataType.class, SignedServiceMetadataType.class}));

    @Override
    public JAXBElement<?> of(ServiceGroup serviceGroup, URI rootUri) {
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier(this.convert(serviceGroup.getParticipantIdentifier()));
        serviceGroupType.setServiceMetadataReferenceCollection(new ServiceMetadataReferenceCollectionType());
        for (ServiceReference serviceReference : serviceGroup.getServiceReferences()) {
            serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference().add(this.convertRef(serviceGroup.getParticipantIdentifier(), serviceReference.getDocumentTypeIdentifier(), rootUri));
        }
        return OBJECT_FACTORY.createServiceGroup(serviceGroupType);
    }

    @Override
    public JAXBElement<?> of(PublisherServiceMetadata serviceMetadata, boolean forSigning) {
        Redirect redirect;
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        ServiceInformation serviceInformation = serviceMetadata.getServiceInformation();
        if (serviceInformation != null) {
            ServiceInformationType serviceInformationType = new ServiceInformationType();
            serviceInformationType.setParticipantIdentifier(this.convert(serviceInformation.getParticipantIdentifier()));
            serviceInformationType.setDocumentIdentifier(this.convert(serviceInformation.getDocumentTypeIdentifier()));
            serviceInformationType.setProcessList(new ProcessListType());
            for (ProcessMetadata processMetadata : serviceInformation.getProcesses()) {
                serviceInformationType.getProcessList().getProcess().addAll(this.convert((ProcessMetadata<PublisherEndpoint>)processMetadata));
            }
            serviceMetadataType.setServiceInformation(serviceInformationType);
        }
        if ((redirect = serviceMetadata.getRedirect()) != null) {
            RedirectType redirectType = OBJECT_FACTORY.createRedirectType();
            redirectType.setCertificateUID(redirect.getCertificateUID());
            redirectType.setHref(redirect.getHref());
            serviceMetadataType.setRedirect(redirectType);
        }
        if (forSigning) {
            SignedServiceMetadataType signedServiceMetadataType = new SignedServiceMetadataType();
            signedServiceMetadataType.setServiceMetadata(serviceMetadataType);
            return OBJECT_FACTORY.createSignedServiceMetadata(signedServiceMetadataType);
        }
        return OBJECT_FACTORY.createServiceMetadata(serviceMetadataType);
    }

    @Override
    public Marshaller getMarshaller() throws JAXBException {
        return JAXB_CONTEXT.createMarshaller();
    }

    private ParticipantIdentifierType convert(ParticipantIdentifier participantIdentifier) {
        ParticipantIdentifierType participantIdentifierType = new ParticipantIdentifierType();
        participantIdentifierType.setScheme(participantIdentifier.getScheme().getIdentifier());
        participantIdentifierType.setValue(participantIdentifier.getIdentifier());
        return participantIdentifierType;
    }

    private ProcessIdentifierType convert(ProcessIdentifier processIdentifier) {
        ProcessIdentifierType processIdentifierType = new ProcessIdentifierType();
        processIdentifierType.setScheme(processIdentifier.getScheme().getIdentifier());
        processIdentifierType.setValue(processIdentifier.getIdentifier());
        return processIdentifierType;
    }

    private DocumentIdentifierType convert(DocumentTypeIdentifier documentTypeIdentifier) {
        DocumentIdentifierType documentIdentifierType = new DocumentIdentifierType();
        documentIdentifierType.setScheme(documentTypeIdentifier.getScheme().getIdentifier());
        documentIdentifierType.setValue(documentTypeIdentifier.getIdentifier());
        return documentIdentifierType;
    }

    private List<ProcessType> convert(ProcessMetadata<PublisherEndpoint> processMetadata) {
        ArrayList<ProcessType> result = new ArrayList<ProcessType>();
        for (ProcessIdentifier processIdentifier : processMetadata.getProcessIdentifier()) {
            ProcessType processType = new ProcessType();
            processType.setProcessIdentifier(this.convert(processIdentifier));
            processType.setServiceEndpointList(new ServiceEndpointList());
            for (PublisherEndpoint endpoint : processMetadata.getEndpoints()) {
                processType.getServiceEndpointList().getEndpoint().add(this.convert(endpoint));
            }
            result.add(processType);
        }
        return result;
    }

    private EndpointType convert(PublisherEndpoint endpoint) {
        EndpointType endpointType = new EndpointType();
        endpointType.setTransportProfile(endpoint.getTransportProfile().getIdentifier());
        endpointType.setRequireBusinessLevelSignature(Boolean.valueOf(false));
        endpointType.setEndpointURI(endpoint.getAddress().toString());
        if (endpoint.getPeriod() != null) {
            endpointType.setServiceActivationDate(this.convert(endpoint.getPeriod().getFrom()));
            endpointType.setServiceExpirationDate(this.convert(endpoint.getPeriod().getTo()));
        }
        endpointType.setCertificate(endpoint.getCertificate());
        endpointType.setServiceDescription(endpoint.getDescription());
        endpointType.setTechnicalContactUrl(endpoint.getTechnicalContact());
        return endpointType;
    }

    private ServiceMetadataReferenceType convertRef(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, URI rootURI) {
        URI uri = rootURI.resolve(String.format("%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded()));
        ServiceMetadataReferenceType serviceMetadataReferenceType = new ServiceMetadataReferenceType();
        serviceMetadataReferenceType.setHref(uri.toString());
        return serviceMetadataReferenceType;
    }
}

