/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.builder;

import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.api.SimpleEndpoint;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceInformation;
import network.oxalis.vefa.peppol.publisher.model.PublisherEndpoint;

public class ServiceInformationBuilder {
    private ParticipantIdentifier participantIdentifier;
    private DocumentTypeIdentifier documentTypeIdentifier;
    private final List<ProcessMetadata<PublisherEndpoint>> processes = new ArrayList<ProcessMetadata<PublisherEndpoint>>();

    public static ServiceInformationBuilder newInstance() {
        return new ServiceInformationBuilder();
    }

    private ServiceInformationBuilder() {
    }

    public ServiceInformationBuilder participant(ParticipantIdentifier participantIdentifier) {
        this.participantIdentifier = participantIdentifier;
        return this;
    }

    public ServiceInformationBuilder documentTypeIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        this.documentTypeIdentifier = documentTypeIdentifier;
        return this;
    }

    public ServiceInformationBuilder add(ProcessIdentifier processIdentifier, PublisherEndpoint ... endpoints) {
        this.processes.add((ProcessMetadata<PublisherEndpoint>)ProcessMetadata.of((ProcessIdentifier)processIdentifier, (SimpleEndpoint[])endpoints));
        return this;
    }

    public ServiceInformationBuilder add(ProcessIdentifier processIdentifier, List<PublisherEndpoint> endpoints) {
        this.processes.add((ProcessMetadata<PublisherEndpoint>)ProcessMetadata.of((ProcessIdentifier)processIdentifier, endpoints));
        return this;
    }

    public ServiceInformation<PublisherEndpoint> build() {
        return ServiceInformation.of((ParticipantIdentifier)this.participantIdentifier, (DocumentTypeIdentifier)this.documentTypeIdentifier, this.processes);
    }
}

