/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher.servlet;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.vefa.peppol.common.lang.PeppolParsingException;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.util.ModelUtils;
import network.oxalis.vefa.peppol.publisher.PublisherService;
import network.oxalis.vefa.peppol.publisher.lang.NotFoundException;
import network.oxalis.vefa.peppol.publisher.lang.PublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PublisherServlet.class);
    private static final Pattern PATH_SERVICE_GROUP = Pattern.compile("^/([a-z0-9\\-]+::[a-z0-9:]+)$");
    private static final Pattern PATH_SERVICE_METADATA = Pattern.compile("^/([a-z0-9\\-]+::[a-z0-9:]+)/services/([a-z0-9\\-]+::.+)$");
    private PublisherService publisherService;

    public PublisherServlet(PublisherService publisherService) {
        this.publisherService = publisherService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String path = ModelUtils.urldecode((String)req.getRequestURI());
            Matcher matcher = PATH_SERVICE_METADATA.matcher(path);
            if (matcher.matches()) {
                this.handleMetadataProvider(req, resp, matcher.group(1), matcher.group(2));
                return;
            }
            matcher = PATH_SERVICE_GROUP.matcher(path);
            if (matcher.matches()) {
                this.handleServiceGroup(req, resp, matcher.group(1));
                return;
            }
            resp.setStatus(404);
        }
        catch (PeppolParsingException e) {
            resp.setStatus(400);
        }
        catch (NotFoundException e) {
            resp.setStatus(404);
        }
        catch (JAXBException | IOException | NullPointerException | PublisherException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(500);
        }
    }

    public void handleServiceGroup(HttpServletRequest req, HttpServletResponse resp, String participantParam) throws IOException, PeppolParsingException, JAXBException, PublisherException {
        ParticipantIdentifier participantIdentifier = ParticipantIdentifier.parse((String)participantParam);
        resp.setContentType("text/xml");
        this.publisherService.serviceGroup((OutputStream)resp.getOutputStream(), req.getParameter("syntax"), URI.create(this.createPublisherRoot(req)), participantIdentifier);
    }

    public void handleMetadataProvider(HttpServletRequest req, HttpServletResponse resp, String participantParam, String documentTypeParam) throws IOException, PeppolParsingException, JAXBException, PublisherException {
        ParticipantIdentifier participantIdentifier = ParticipantIdentifier.parse((String)participantParam);
        DocumentTypeIdentifier documentTypeIdentifier = DocumentTypeIdentifier.parse((String)documentTypeParam);
        resp.setContentType("text/xml");
        this.publisherService.metadataProvider((OutputStream)resp.getOutputStream(), req.getParameter("syntax"), participantIdentifier, documentTypeIdentifier);
    }

    private String createPublisherRoot(HttpServletRequest req) {
        if (req.getServerPort() == 80 && req.getScheme().equalsIgnoreCase("http") || req.getServerPort() == 443 && req.getScheme().equalsIgnoreCase("https")) {
            return req.getScheme() + "://" + req.getServerName() + "/";
        }
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + "/";
    }
}

