/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.publisher;

import jakarta.servlet.http.HttpServlet;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.OutputStream;
import java.net.URI;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.publisher.PublisherSyntaxProvider;
import network.oxalis.vefa.peppol.publisher.Signer;
import network.oxalis.vefa.peppol.publisher.api.PublisherSyntax;
import network.oxalis.vefa.peppol.publisher.api.ServiceGroupProvider;
import network.oxalis.vefa.peppol.publisher.api.ServiceMetadataProvider;
import network.oxalis.vefa.peppol.publisher.lang.PublisherException;
import network.oxalis.vefa.peppol.publisher.model.PublisherServiceMetadata;
import network.oxalis.vefa.peppol.publisher.model.ServiceGroup;
import network.oxalis.vefa.peppol.security.xmldsig.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PublisherService
extends HttpServlet {
    private ServiceGroupProvider serviceGroupProvider;
    private ServiceMetadataProvider serviceMetadataProvider;
    private PublisherSyntaxProvider publisherSyntaxProvider;
    private Signer signer;

    public PublisherService(ServiceGroupProvider serviceGroupProvider, ServiceMetadataProvider serviceMetadataProvider, PublisherSyntaxProvider publisherSyntaxProvider, Signer signer) {
        this.serviceGroupProvider = serviceGroupProvider;
        this.serviceMetadataProvider = serviceMetadataProvider;
        this.publisherSyntaxProvider = publisherSyntaxProvider;
        this.signer = signer;
    }

    public void serviceGroup(OutputStream outputStream, String syntax, URI rootUri, ParticipantIdentifier participantIdentifier) throws JAXBException, PublisherException {
        ServiceGroup serviceGroup = this.serviceGroupProvider.get(participantIdentifier);
        PublisherSyntax publisherSyntax = this.publisherSyntaxProvider.getSyntax(syntax);
        Marshaller marshaller = publisherSyntax.getMarshaller();
        marshaller.marshal(publisherSyntax.of(serviceGroup, rootUri), outputStream);
    }

    public void metadataProvider(OutputStream outputStream, String syntax, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier) throws JAXBException, PublisherException {
        PublisherServiceMetadata serviceMetadata = this.serviceMetadataProvider.get(participantIdentifier, documentTypeIdentifier);
        PublisherSyntax publisherSyntax = this.publisherSyntaxProvider.getSyntax(syntax);
        Marshaller marshaller = publisherSyntax.getMarshaller();
        if (this.signer == null) {
            marshaller.marshal(publisherSyntax.of(serviceMetadata, false), outputStream);
        } else {
            Document document = DomUtils.newDocumentBuilder().newDocument();
            marshaller.marshal(publisherSyntax.of(serviceMetadata, true), (Node)document);
            this.signer.sign(document, outputStream);
        }
    }
}

