/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh;

import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import network.oxalis.peppol.sbdh.jaxb.DocumentIdentification;
import network.oxalis.peppol.sbdh.jaxb.PartnerIdentification;
import network.oxalis.peppol.sbdh.jaxb.Scope;
import network.oxalis.peppol.sbdh.jaxb.StandardBusinessDocumentHeader;
import network.oxalis.vefa.peppol.common.model.ArgumentIdentifier;
import network.oxalis.vefa.peppol.common.model.C1CountryIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceType;
import network.oxalis.vefa.peppol.common.model.MlsToIdentifier;
import network.oxalis.vefa.peppol.common.model.MlsTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.sbdh.SbdhHelper;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;

public interface SbdhReader {
    public static Header read(InputStream inputStream) throws SbdhException {
        try {
            XMLStreamReader reader = SbdhHelper.XML_INPUT_FACTORY.createXMLStreamReader(inputStream);
            Unmarshaller unmarshaller = SbdhHelper.JAXB_CONTEXT.createUnmarshaller();
            return SbdhReader.read((StandardBusinessDocumentHeader)unmarshaller.unmarshal(reader, StandardBusinessDocumentHeader.class).getValue());
        }
        catch (Exception e) {
            throw new SbdhException("Unable to unmarshal content to SBDH.", e);
        }
    }

    public static Header read(XMLStreamReader xmlStreamReader) throws SbdhException {
        try {
            Unmarshaller unmarshaller = SbdhHelper.JAXB_CONTEXT.createUnmarshaller();
            return SbdhReader.read((StandardBusinessDocumentHeader)unmarshaller.unmarshal(xmlStreamReader, StandardBusinessDocumentHeader.class).getValue());
        }
        catch (Exception e) {
            throw new SbdhException("Unable to unmarshal content to SBDH.", e);
        }
    }

    public static Header read(StandardBusinessDocumentHeader sbdh) throws SbdhException {
        Header header = Header.newInstance();
        SbdhException.notNull("Sender is not provided in SBDH.", sbdh.getSender());
        SbdhException.notNull("Sender identifier is not provided in SBDH.", sbdh.getSender().getIdentifier());
        PartnerIdentification senderIdentifier = sbdh.getSender().getIdentifier();
        header = header.sender(ParticipantIdentifier.of((String)senderIdentifier.getValue(), (Scheme)Scheme.of((String)senderIdentifier.getAuthority())));
        SbdhException.notNull("Receiver is not provided in SBDH.", sbdh.getReceiver());
        SbdhException.notNull("Receiver identifier is not provided in SBDH.", sbdh.getReceiver().getIdentifier());
        PartnerIdentification receiverIdentifier = sbdh.getReceiver().getIdentifier();
        header = header.receiver(ParticipantIdentifier.of((String)receiverIdentifier.getValue(), (Scheme)Scheme.of((String)receiverIdentifier.getAuthority())));
        DocumentIdentification docIdent = sbdh.getDocumentIdentification();
        SbdhException.notNull("Document identification is not provided in SBDH.", docIdent);
        SbdhException.notNull("SBDH instance identifier is not provided in SBDH.", docIdent.getInstanceIdentifier());
        header = header.identifier(InstanceIdentifier.of((String)docIdent.getInstanceIdentifier()));
        SbdhException.notNull("Information about standard is not provided in SBDH.", docIdent.getStandard());
        SbdhException.notNull("Information about type is not provided in SBDH.", docIdent.getType());
        SbdhException.notNull("Information about type version is not provided in SBDH.", docIdent.getTypeVersion());
        header = header.instanceType(InstanceType.of((String)docIdent.getStandard(), (String)docIdent.getType(), (String)docIdent.getTypeVersion()));
        SbdhException.notNull("Element 'CreationDateAndTime' is not set or contains invalid value.", docIdent.getCreationDateAndTime());
        header = header.creationTimestamp(SbdhHelper.fromXMLGregorianCalendar(docIdent.getCreationDateAndTime()));
        block14: for (Scope scope : sbdh.getBusinessScope().getScope()) {
            String type;
            switch (type = scope.getType().trim()) {
                case "DOCUMENTID": {
                    Scheme scheme = scope.getIdentifier() != null ? Scheme.of((String)scope.getIdentifier()) : DocumentTypeIdentifier.BUSDOX_DOCID_QNS_SCHEME;
                    header = header.documentType(DocumentTypeIdentifier.of((String)scope.getInstanceIdentifier(), (Scheme)scheme));
                    continue block14;
                }
                case "PROCESSID": {
                    Scheme scheme = scope.getIdentifier() != null ? Scheme.of((String)scope.getIdentifier()) : ProcessIdentifier.DEFAULT_SCHEME;
                    header = header.process(ProcessIdentifier.of((String)scope.getInstanceIdentifier(), (Scheme)scheme));
                    continue block14;
                }
                case "COUNTRY_C1": {
                    header = header.c1CountryIdentifier(C1CountryIdentifier.of((String)scope.getInstanceIdentifier()));
                    continue block14;
                }
                case "MLS_TO": {
                    Scheme scheme = scope.getIdentifier() != null ? Scheme.of((String)scope.getIdentifier()) : MlsToIdentifier.DEFAULT_SCHEME;
                    header = header.mlsToIdentifier(MlsToIdentifier.of((String)scope.getInstanceIdentifier(), (Scheme)scheme));
                    continue block14;
                }
                case "MLS_TYPE": {
                    header = header.mlsTypeIdentifier(MlsTypeIdentifier.of((String)scope.getInstanceIdentifier()));
                    continue block14;
                }
            }
            header = header.argument(ArgumentIdentifier.of((String)type, (String)scope.getInstanceIdentifier()));
        }
        SbdhException.notNull("Scope containing document identifier is not provided in SBDH.", header.getDocumentType());
        SbdhException.notNull("Scope containing process identifier is not provided in SBDH.", header.getProcess());
        return header;
    }
}

