/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.security;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeDetector {
    private static final Logger log = LoggerFactory.getLogger(ModeDetector.class);

    public static Mode detect(X509Certificate certificate) throws PeppolLoadingException {
        return ModeDetector.detect(certificate, ConfigFactory.load(), null);
    }

    public static Mode detect(X509Certificate certificate, Config config, Map<String, Object> objectStorage) throws PeppolLoadingException {
        for (String token : config.getObject("mode").keySet()) {
            if ("default".equals(token)) continue;
            try {
                Mode mode = Mode.of((Config)config, (String)token);
                ((CertificateValidator)mode.initiate("security.validator.class", CertificateValidator.class, objectStorage)).validate(Service.ALL, certificate);
                log.info("Detected mode: {}", (Object)mode.getIdentifier());
                if (mode.hasString("security.message")) {
                    log.info(mode.getString("security.message"));
                }
                return mode;
            }
            catch (PeppolSecurityException e) {
                log.info("Detection error ({}): {}", (Object)token, (Object)e.getMessage());
            }
        }
        throw new PeppolLoadingException(String.format("Unable to detect mode for certificate '%s'.", certificate.getSubjectDN().toString()));
    }
}

