/*
 * Decompiled with CFR 0.152.
 */
package network.qloud.integrations.boot.logout;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"${qloud.logout-path}"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0012J\u001c\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0017\u00a8\u0006\u000b"}, d2={"Lnetwork/qloud/integrations/boot/logout/LogoutController;", "", "()V", "buildLogoutUrl", "", "issuerUri", "returnPath", "logout", "authentication", "Lorg/springframework/security/oauth2/server/resource/authentication/JwtAuthenticationToken;", "Companion", "qloud-spring-boot-starter"})
public class LogoutController {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    public static final String QLOUD_LOGOUT_PATH = "logout";
    @Deprecated
    @NotNull
    public static final String QLOUD_RETURN_PATH_PARAM = "return_path";

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @NotNull
    public String logout(@NotNull JwtAuthenticationToken authentication, @RequestParam(value="return_path") @Nullable String returnPath) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        String issuerUri = ((Jwt)authentication.getToken()).getIssuer().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)issuerUri, (String)"issuerUri");
        String logoutUrl = this.buildLogoutUrl(issuerUri, returnPath);
        return "redirect:" + logoutUrl;
    }

    private String buildLogoutUrl(String issuerUri, String returnPath) {
        String[] stringArray = new String[]{QLOUD_LOGOUT_PATH};
        String[] builder = stringArray = UriComponentsBuilder.fromUriString((String)issuerUri).pathSegment(stringArray);
        boolean bl = false;
        Object[] objectArray = (Object[])returnPath;
        if (!(objectArray == null || StringsKt.isBlank((CharSequence)objectArray))) {
            objectArray = new Object[]{returnPath};
            builder.queryParam(QLOUD_RETURN_PATH_PARAM, objectArray);
        }
        String string = stringArray.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromUriString(issuerUri)\u2026           .toUriString()");
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnetwork/qloud/integrations/boot/logout/LogoutController$Companion;", "", "()V", "QLOUD_LOGOUT_PATH", "", "QLOUD_RETURN_PATH_PARAM", "qloud-spring-boot-starter"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

