/*
 * Decompiled with CFR 0.152.
 */
package network.qloud.integrations.boot;

import java.time.Duration;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import network.qloud.integrations.boot.QloudProperties;
import network.qloud.integrations.boot.QloudTokenResolver;
import network.qloud.integrations.boot.QloudUserArgumentResolver;
import network.qloud.integrations.boot.api.QloudApi;
import network.qloud.integrations.boot.api.WebClientQloudApi;
import network.qloud.integrations.boot.logout.LogoutController;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import reactor.netty.http.client.HttpClient;

@AutoConfiguration(before={OAuth2ResourceServerAutoConfiguration.class}, after={WebClientAutoConfiguration.class})
@ConditionalOnProperty(value={"qloud.secret"})
@EnableConfigurationProperties(value={QloudProperties.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnetwork/qloud/integrations/boot/QloudAutoConfiguration;", "", "properties", "Lnetwork/qloud/integrations/boot/QloudProperties;", "(Lnetwork/qloud/integrations/boot/QloudProperties;)V", "bearerTokenResolver", "Lorg/springframework/security/oauth2/server/resource/web/BearerTokenResolver;", "jwtDecoder", "Lorg/springframework/security/oauth2/jwt/JwtDecoder;", "logoutController", "Lnetwork/qloud/integrations/boot/logout/LogoutController;", "qloudApi", "Lnetwork/qloud/integrations/boot/api/QloudApi;", "connector", "Lorg/springframework/http/client/reactive/ClientHttpConnector;", "qloudApiHttpConnector", "QloudSecurityConfiguration", "QloudWebMvcConfiguration", "qloud-spring-boot-starter"})
public class QloudAutoConfiguration {
    @NotNull
    private final QloudProperties properties;

    public QloudAutoConfiguration(@NotNull QloudProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
    }

    @Bean
    @NotNull
    public JwtDecoder jwtDecoder() {
        String string = this.properties.getSecret();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String $this$jwtDecoder_u24lambda_u240 = string = NimbusJwtDecoder.withSecretKey((SecretKey)new SecretKeySpec(byArray, "AES")).macAlgorithm(MacAlgorithm.HS256).build();
        boolean bl = false;
        $this$jwtDecoder_u24lambda_u240.setJwtValidator((OAuth2TokenValidator)new JwtTimestampValidator(Duration.ofSeconds(this.properties.getClockSkewSeconds())));
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"withSecretKey(SecretKeyS\u2026wSeconds)))\n            }");
        return (JwtDecoder)string2;
    }

    @Bean
    @NotNull
    public BearerTokenResolver bearerTokenResolver() {
        return new QloudTokenResolver();
    }

    @Bean
    @ConditionalOnExpression(value="not '${qloud.logout-path:}'.isBlank()")
    @NotNull
    public LogoutController logoutController() {
        return new LogoutController();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(name={"qloudApiHttpConnector"})
    @NotNull
    public ClientHttpConnector qloudApiHttpConnector() {
        return (ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create().compress(true).followRedirect(true));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="not '${qloud.domain:}'.isBlank()")
    @NotNull
    public QloudApi qloudApi(@NotNull ClientHttpConnector connector) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        return new WebClientQloudApi(connector, "https://" + this.properties.getDomain() + "/.q/api/management", this.properties.getSecret());
    }

    @Configuration
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnetwork/qloud/integrations/boot/QloudAutoConfiguration$QloudWebMvcConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "()V", "addArgumentResolvers", "", "resolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "qloud-spring-boot-starter"})
    public static class QloudWebMvcConfiguration
    implements WebMvcConfigurer {
        public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
            Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
            resolvers.add(new QloudUserArgumentResolver());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SecurityFilterChain.class})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lnetwork/qloud/integrations/boot/QloudAutoConfiguration$QloudSecurityConfiguration;", "", "()V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "qloud-spring-boot-starter"})
    public static class QloudSecurityConfiguration {
        @Bean
        @NotNull
        public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http) {
            Intrinsics.checkNotNullParameter((Object)http, (String)"http");
            Object object = http.oauth2ResourceServer(QloudSecurityConfiguration::securityFilterChain$lambda$0).authorizeHttpRequests(QloudSecurityConfiguration::securityFilterChain$lambda$1).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"http.oauth2ResourceServe\u2026                }.build()");
            return (SecurityFilterChain)object;
        }

        private static final void securityFilterChain$lambda$0(OAuth2ResourceServerConfigurer configurer) {
            configurer.jwt();
        }

        private static final void securityFilterChain$lambda$1(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorize) {
            ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
    }
}

