/*
 * Decompiled with CFR 0.152.
 */
package network.qloud.integrations.boot.api;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.qloud.integrations.boot.api.QloudApi;
import network.qloud.integrations.boot.api.dto.QloudApiUser;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnetwork/qloud/integrations/boot/api/WebClientQloudApi;", "Lnetwork/qloud/integrations/boot/api/QloudApi;", "clientConnector", "Lorg/springframework/http/client/reactive/ClientHttpConnector;", "baseUrl", "", "secret", "(Lorg/springframework/http/client/reactive/ClientHttpConnector;Ljava/lang/String;Ljava/lang/String;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "deleteUser", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "id", "getUser", "Lnetwork/qloud/integrations/boot/api/dto/QloudApiUser;", "userUri", "qloud-spring-boot-starter"})
public final class WebClientQloudApi
implements QloudApi {
    @NotNull
    private final WebClient webClient;

    public WebClientQloudApi(@NotNull ClientHttpConnector clientConnector, @NotNull String baseUrl, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)clientConnector, (String)"clientConnector");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        String[] stringArray = new String[]{secret};
        WebClient webClient = WebClient.builder().baseUrl(baseUrl).clientConnector(clientConnector).defaultHeader("Authorization", stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"builder().baseUrl(baseUr\u2026 secret)\n        .build()");
        this.webClient = webClient;
    }

    @Override
    @NotNull
    public CompletableFuture<QloudApiUser> getUser(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CompletableFuture completableFuture = this.webClient.get().uri(this.userUri(id), new Object[0]).retrieve().bodyToMono(QloudApiUser.class).toFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"webClient.get().uri(user\u2026)\n            .toFuture()");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> deleteUser(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        WebClient.ResponseSpec responseSpec = this.webClient.delete().uri(this.userUri(id), new Object[0]).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"webClient.delete().uri(userUri(id)).retrieve()");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<Void>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        CompletableFuture completableFuture = mono.toFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"webClient.delete().uri(u\u2026)\n            .toFuture()");
        return completableFuture;
    }

    private final String userUri(String id) {
        return "/users/" + id;
    }
}

