/*
 * Decompiled with CFR 0.152.
 */
package network.qloud.integrations.boot.test;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.oauth2.jwt.Jwt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eBC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnetwork/qloud/integrations/boot/test/QloudJwtBuilder;", "", "subject", "", "name", "email", "identityProvider", "identityProviderSubject", "userDatabase", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "build", "Lorg/springframework/security/oauth2/jwt/Jwt;", "secret", "", "Companion", "qloud-spring-boot-starter"})
public final class QloudJwtBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private String subject;
    @NotNull
    private String name;
    @Nullable
    private String email;
    @NotNull
    private String identityProvider;
    @NotNull
    private String identityProviderSubject;
    @NotNull
    private String userDatabase;
    @Deprecated
    @NotNull
    private static final byte[] DEFAULT_SECRET;

    public QloudJwtBuilder(@NotNull String subject, @NotNull String name, @Nullable String email, @NotNull String identityProvider, @NotNull String identityProviderSubject, @NotNull String userDatabase) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)identityProvider, (String)"identityProvider");
        Intrinsics.checkNotNullParameter((Object)identityProviderSubject, (String)"identityProviderSubject");
        Intrinsics.checkNotNullParameter((Object)userDatabase, (String)"userDatabase");
        this.subject = subject;
        this.name = name;
        this.email = email;
        this.identityProvider = identityProvider;
        this.identityProviderSubject = identityProviderSubject;
        this.userDatabase = userDatabase;
    }

    public /* synthetic */ QloudJwtBuilder(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string7 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"randomUUID().toString()");
            string = string7;
        }
        if ((n & 2) != 0) {
            string2 = "Max Power";
        }
        if ((n & 4) != 0) {
            string3 = "max.power@qloud.network";
        }
        if ((n & 8) != 0) {
            string4 = "google";
        }
        if ((n & 0x10) != 0) {
            string5 = "123";
        }
        if ((n & 0x20) != 0) {
            String string8 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"randomUUID().toString()");
            string6 = string8;
        }
        this(string, string2, string3, string4, string5, string6);
    }

    @NotNull
    public final QloudJwtBuilder subject(@NotNull String subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        this.subject = subject;
        return this;
    }

    @NotNull
    public final QloudJwtBuilder name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @NotNull
    public final QloudJwtBuilder email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @NotNull
    public final QloudJwtBuilder identityProvider(@NotNull String identityProvider) {
        Intrinsics.checkNotNullParameter((Object)identityProvider, (String)"identityProvider");
        this.identityProvider = identityProvider;
        return this;
    }

    @NotNull
    public final QloudJwtBuilder identityProviderSubject(@NotNull String identityProviderSubject) {
        Intrinsics.checkNotNullParameter((Object)identityProviderSubject, (String)"identityProviderSubject");
        this.identityProviderSubject = identityProviderSubject;
        return this;
    }

    @NotNull
    public final QloudJwtBuilder userDatabase(@NotNull String userDatabase) {
        Intrinsics.checkNotNullParameter((Object)userDatabase, (String)"userDatabase");
        this.userDatabase = userDatabase;
        return this;
    }

    @NotNull
    public final Jwt build(@NotNull byte[] secret) {
        SignedJWT signedJWT;
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        if (!(secret.length == 32)) {
            boolean $i$a$-require-QloudJwtBuilder$build$22 = false;
            String $i$a$-require-QloudJwtBuilder$build$22 = "secret must consist of exactly 32 bytes";
            throw new IllegalArgumentException($i$a$-require-QloudJwtBuilder$build$22.toString());
        }
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().subject(this.subject).claim("name", (Object)this.name).claim("email", (Object)this.email).claim("q:idp", (Object)this.identityProvider).claim("q:idp-sub", (Object)this.identityProviderSubject).claim("q:udb", (Object)this.userDatabase).build();
        SignedJWT $this$build_u24lambda_u241 = signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimSet);
        boolean bl = false;
        $this$build_u24lambda_u241.sign((JWSSigner)new MACSigner(secret));
        SignedJWT signedJwt = signedJWT;
        Jwt jwt = Jwt.withTokenValue((String)signedJwt.serialize()).header("alg", (Object)"HS256").claims(arg_0 -> QloudJwtBuilder.build$lambda$2(claimSet, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jwt, (String)"withTokenValue(signedJwt\u2026s) }\n            .build()");
        return jwt;
    }

    public static /* synthetic */ Jwt build$default(QloudJwtBuilder qloudJwtBuilder, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = DEFAULT_SECRET;
        }
        return qloudJwtBuilder.build(byArray);
    }

    private static final void build$lambda$2(JWTClaimsSet $claimSet, Map claims) {
        Map map = $claimSet.getClaims();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"claimSet.claims");
        claims.putAll(map);
    }

    public QloudJwtBuilder() {
        this(null, null, null, null, null, null, 63, null);
    }

    static {
        String string = "qsecretqsecretqsecretqsecretqsec";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        DEFAULT_SECRET = byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnetwork/qloud/integrations/boot/test/QloudJwtBuilder$Companion;", "", "()V", "DEFAULT_SECRET", "", "getDEFAULT_SECRET", "()[B", "qloud-spring-boot-starter"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getDEFAULT_SECRET() {
            return DEFAULT_SECRET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

