/*
 * Decompiled with CFR 0.152.
 */
package network.unique.signer;

import network.unique.signer.CryptoScheme;
import network.unique.signer.Signer;

public class Pair {
    long nativeHandle;

    private Pair(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    public byte[] sign(byte[] message) {
        byte[] result = Signer.jPairSign(this.nativeHandle, message);
        if (result == null) {
            throw new IllegalStateException("unknown native failure");
        }
        return result;
    }

    public static Pair fromSuri(CryptoScheme scheme, String suri, String password) {
        long nativeHandle = Signer.jPairInitSuri(scheme.ordinal(), suri, password);
        if (nativeHandle == 0L) {
            throw new IllegalStateException("unknown native failure");
        }
        return new Pair(nativeHandle);
    }

    public void close() {
        Signer.jPairFree(this.nativeHandle);
    }
}

