/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package network.unique.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import network.unique.model.ExtrinsicResultResponse
import network.unique.model.ExtrinsicsControllerCalculateFeeRequest
import network.unique.model.FeeResponse
import network.unique.model.GetExtrinsicResponse
import network.unique.model.SignTxResultResponse
import network.unique.model.SubmitResultResponse
import network.unique.model.SubmitTxBody
import network.unique.model.TxBuildBody
import network.unique.model.UnsignedTxPayloadBody
import network.unique.model.UnsignedTxPayloadResponse
import network.unique.model.VerificationResultResponse

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class ExtrinsicApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost")
        }
    }

    /**
     * 
     * 
     * @param txBuildBody 
     * @return UnsignedTxPayloadResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerBuildTx(txBuildBody: TxBuildBody) : UnsignedTxPayloadResponse {
        val localVarResponse = extrinsicsControllerBuildTxWithHttpInfo(txBuildBody = txBuildBody)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as UnsignedTxPayloadResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param txBuildBody 
     * @return ApiResponse<UnsignedTxPayloadResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerBuildTxWithHttpInfo(txBuildBody: TxBuildBody) : ApiResponse<UnsignedTxPayloadResponse?> {
        val localVariableConfig = extrinsicsControllerBuildTxRequestConfig(txBuildBody = txBuildBody)

        return request<TxBuildBody, UnsignedTxPayloadResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerBuildTx
     *
     * @param txBuildBody 
     * @return RequestConfig
     */
    fun extrinsicsControllerBuildTxRequestConfig(txBuildBody: TxBuildBody) : RequestConfig<TxBuildBody> {
        val localVariableBody = txBuildBody
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/extrinsic/build",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param extrinsicsControllerCalculateFeeRequest 
     * @return FeeResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerCalculateFee(extrinsicsControllerCalculateFeeRequest: ExtrinsicsControllerCalculateFeeRequest) : FeeResponse {
        val localVarResponse = extrinsicsControllerCalculateFeeWithHttpInfo(extrinsicsControllerCalculateFeeRequest = extrinsicsControllerCalculateFeeRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as FeeResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param extrinsicsControllerCalculateFeeRequest 
     * @return ApiResponse<FeeResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerCalculateFeeWithHttpInfo(extrinsicsControllerCalculateFeeRequest: ExtrinsicsControllerCalculateFeeRequest) : ApiResponse<FeeResponse?> {
        val localVariableConfig = extrinsicsControllerCalculateFeeRequestConfig(extrinsicsControllerCalculateFeeRequest = extrinsicsControllerCalculateFeeRequest)

        return request<ExtrinsicsControllerCalculateFeeRequest, FeeResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerCalculateFee
     *
     * @param extrinsicsControllerCalculateFeeRequest 
     * @return RequestConfig
     */
    fun extrinsicsControllerCalculateFeeRequestConfig(extrinsicsControllerCalculateFeeRequest: ExtrinsicsControllerCalculateFeeRequest) : RequestConfig<ExtrinsicsControllerCalculateFeeRequest> {
        val localVariableBody = extrinsicsControllerCalculateFeeRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/extrinsic/calculate-fee",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param blockHashOrNumber 
     * @param extrinsicHash 
     * @return GetExtrinsicResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerGet(blockHashOrNumber: kotlin.String, extrinsicHash: kotlin.String) : GetExtrinsicResponse {
        val localVarResponse = extrinsicsControllerGetWithHttpInfo(blockHashOrNumber = blockHashOrNumber, extrinsicHash = extrinsicHash)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as GetExtrinsicResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param blockHashOrNumber 
     * @param extrinsicHash 
     * @return ApiResponse<GetExtrinsicResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerGetWithHttpInfo(blockHashOrNumber: kotlin.String, extrinsicHash: kotlin.String) : ApiResponse<GetExtrinsicResponse?> {
        val localVariableConfig = extrinsicsControllerGetRequestConfig(blockHashOrNumber = blockHashOrNumber, extrinsicHash = extrinsicHash)

        return request<Unit, GetExtrinsicResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerGet
     *
     * @param blockHashOrNumber 
     * @param extrinsicHash 
     * @return RequestConfig
     */
    fun extrinsicsControllerGetRequestConfig(blockHashOrNumber: kotlin.String, extrinsicHash: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("blockHashOrNumber", listOf(blockHashOrNumber.toString()))
                put("extrinsicHash", listOf(extrinsicHash.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/extrinsic",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param hash 
     * @return ExtrinsicResultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerGetStatus(hash: kotlin.String) : ExtrinsicResultResponse {
        val localVarResponse = extrinsicsControllerGetStatusWithHttpInfo(hash = hash)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ExtrinsicResultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param hash 
     * @return ApiResponse<ExtrinsicResultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerGetStatusWithHttpInfo(hash: kotlin.String) : ApiResponse<ExtrinsicResultResponse?> {
        val localVariableConfig = extrinsicsControllerGetStatusRequestConfig(hash = hash)

        return request<Unit, ExtrinsicResultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerGetStatus
     *
     * @param hash 
     * @return RequestConfig
     */
    fun extrinsicsControllerGetStatusRequestConfig(hash: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("hash", listOf(hash.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/extrinsic/status",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * Use the Authorization request header to provide authentication information &lt;ul&gt; &lt;li&gt;&lt;code&gt;Authorization: Seed &amp;lt;your mnemonic phrase | uri name&amp;gt;&lt;/code&gt;&lt;/li&gt; &lt;/ul&gt;
     * @param unsignedTxPayloadBody 
     * @return SignTxResultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerSign(unsignedTxPayloadBody: UnsignedTxPayloadBody) : SignTxResultResponse {
        val localVarResponse = extrinsicsControllerSignWithHttpInfo(unsignedTxPayloadBody = unsignedTxPayloadBody)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SignTxResultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Use the Authorization request header to provide authentication information &lt;ul&gt; &lt;li&gt;&lt;code&gt;Authorization: Seed &amp;lt;your mnemonic phrase | uri name&amp;gt;&lt;/code&gt;&lt;/li&gt; &lt;/ul&gt;
     * @param unsignedTxPayloadBody 
     * @return ApiResponse<SignTxResultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerSignWithHttpInfo(unsignedTxPayloadBody: UnsignedTxPayloadBody) : ApiResponse<SignTxResultResponse?> {
        val localVariableConfig = extrinsicsControllerSignRequestConfig(unsignedTxPayloadBody = unsignedTxPayloadBody)

        return request<UnsignedTxPayloadBody, SignTxResultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerSign
     *
     * @param unsignedTxPayloadBody 
     * @return RequestConfig
     */
    fun extrinsicsControllerSignRequestConfig(unsignedTxPayloadBody: UnsignedTxPayloadBody) : RequestConfig<UnsignedTxPayloadBody> {
        val localVariableBody = unsignedTxPayloadBody
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/extrinsic/sign",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param submitTxBody 
     * @return SubmitResultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerSubmitTx(submitTxBody: SubmitTxBody) : SubmitResultResponse {
        val localVarResponse = extrinsicsControllerSubmitTxWithHttpInfo(submitTxBody = submitTxBody)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SubmitResultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param submitTxBody 
     * @return ApiResponse<SubmitResultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerSubmitTxWithHttpInfo(submitTxBody: SubmitTxBody) : ApiResponse<SubmitResultResponse?> {
        val localVariableConfig = extrinsicsControllerSubmitTxRequestConfig(submitTxBody = submitTxBody)

        return request<SubmitTxBody, SubmitResultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerSubmitTx
     *
     * @param submitTxBody 
     * @return RequestConfig
     */
    fun extrinsicsControllerSubmitTxRequestConfig(submitTxBody: SubmitTxBody) : RequestConfig<SubmitTxBody> {
        val localVariableBody = submitTxBody
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/extrinsic/submit",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param submitTxBody 
     * @return VerificationResultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun extrinsicsControllerVerifySign(submitTxBody: SubmitTxBody) : VerificationResultResponse {
        val localVarResponse = extrinsicsControllerVerifySignWithHttpInfo(submitTxBody = submitTxBody)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VerificationResultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param submitTxBody 
     * @return ApiResponse<VerificationResultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun extrinsicsControllerVerifySignWithHttpInfo(submitTxBody: SubmitTxBody) : ApiResponse<VerificationResultResponse?> {
        val localVariableConfig = extrinsicsControllerVerifySignRequestConfig(submitTxBody = submitTxBody)

        return request<SubmitTxBody, VerificationResultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation extrinsicsControllerVerifySign
     *
     * @param submitTxBody 
     * @return RequestConfig
     */
    fun extrinsicsControllerVerifySignRequestConfig(submitTxBody: SubmitTxBody) : RequestConfig<SubmitTxBody> {
        val localVariableBody = submitTxBody
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/extrinsic/verify-sign",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
