/*
 * Decompiled with CFR 0.152.
 */
package network.unique.model;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import network.unique.model.SignerWrapper;
import network.unique.model.Sr25519SignerWrapper;
import network.unique.signer.CryptoScheme;
import network.unique.signer.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnetwork/unique/model/Sr25519SignerWrapper;", "Lnetwork/unique/model/SignerWrapper;", "seed", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "sign", "data", "unique-sdk"})
public final class Sr25519SignerWrapper
implements SignerWrapper {
    @NotNull
    private final String seed;
    @Nullable
    private final String password;

    public Sr25519SignerWrapper(@NotNull String seed, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        this.seed = seed;
        this.password = password;
    }

    @Override
    @NotNull
    public String sign(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pair keyPair = Pair.fromSuri((CryptoScheme)CryptoScheme.Sr25519, (String)this.seed, (String)this.password);
        String string = data.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        byte[] byArray = keyPair.sign(this.toByteArray(string));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.sign(toByteArray(data.substring(2)))");
        String signature2 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sign.signature.1.INSTANCE, (int)30, null);
        return "0x01" + signature2;
    }

    @Override
    @NotNull
    public byte[] toByteArray(@NotNull String data) {
        return SignerWrapper.DefaultImpls.toByteArray(this, data);
    }
}

