/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.AddressUtilsApi;
import network.unique.model.AddressDto;
import network.unique.model.EthereumAddressDto;
import network.unique.model.NestingAddressDto;
import network.unique.model.TokenIdQuery;
import network.unique.service.AddressUtilsService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnetwork/unique/service/impl/AddressUtilsServiceImpl;", "Lnetwork/unique/service/AddressUtilsService;", "basePath", "", "(Ljava/lang/String;)V", "api", "Lnetwork/unique/api/AddressUtilsApi;", "addressToIds", "Lnetwork/unique/model/TokenIdQuery;", "address", "ethereumToSubstrate", "Lnetwork/unique/model/AddressDto;", "idsToAddress", "Lnetwork/unique/model/NestingAddressDto;", "collectionId", "Ljava/math/BigDecimal;", "tokenId", "at", "normalize", "ss58prefix", "substrateToEthereum", "Lnetwork/unique/model/EthereumAddressDto;", "unique-sdk"})
public final class AddressUtilsServiceImpl
implements AddressUtilsService {
    @NotNull
    private final AddressUtilsApi api;

    public AddressUtilsServiceImpl(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new AddressUtilsApi(basePath, null, 2, null);
    }

    @Override
    @NotNull
    public NestingAddressDto idsToAddress(@NotNull BigDecimal collectionId, @NotNull BigDecimal tokenId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.addressUtilsControllerNestingTokenIdToAddress(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TokenIdQuery addressToIds(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.api.addressUtilsControllerNestingAddressToCollection(address);
    }

    @Override
    @NotNull
    public EthereumAddressDto substrateToEthereum(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.api.addressUtilsControllerSubstrateToEthereum(address);
    }

    @Override
    @NotNull
    public AddressDto ethereumToSubstrate(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.api.addressUtilsControllerEthereumToSubstrate(address);
    }

    @Override
    @NotNull
    public AddressDto normalize(@NotNull String address, @NotNull BigDecimal ss58prefix) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)ss58prefix, (String)"ss58prefix");
        return this.api.addressUtilsControllerNormalize(address, ss58prefix);
    }
}

