/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.BalanceApi;
import network.unique.model.AllBalancesResponse;
import network.unique.model.SignerWrapper;
import network.unique.model.TransferBody;
import network.unique.service.BalanceService;
import network.unique.service.MutationService;
import network.unique.service.impl.balance.TransferMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnetwork/unique/service/impl/BalanceServiceImpl;", "Lnetwork/unique/service/BalanceService;", "signerWrapper", "Lnetwork/unique/model/SignerWrapper;", "basePath", "", "(Lnetwork/unique/model/SignerWrapper;Ljava/lang/String;)V", "api", "Lnetwork/unique/api/BalanceApi;", "transferMutationService", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/TransferBody;", "getBalance", "Lnetwork/unique/model/AllBalancesResponse;", "address", "getTransferMutationService", "unique-sdk"})
public final class BalanceServiceImpl
implements BalanceService {
    @NotNull
    private final BalanceApi api;
    @NotNull
    private final MutationService<TransferBody> transferMutationService;

    public BalanceServiceImpl(@NotNull SignerWrapper signerWrapper, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)signerWrapper, (String)"signerWrapper");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new BalanceApi(basePath, null, 2, null);
        this.transferMutationService = new TransferMutationServiceImpl(signerWrapper, basePath);
    }

    @Override
    @NotNull
    public AllBalancesResponse getBalance(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.api.balanceControllerGetBalance(address);
    }

    @Override
    @NotNull
    public MutationService<TransferBody> getTransferMutationService() {
        return this.transferMutationService;
    }
}

