/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.CollectionsApi;
import network.unique.model.AddCollectionAdminBody;
import network.unique.model.AddToAllowListBody;
import network.unique.model.AdminlistResponse;
import network.unique.model.AllowListBodyResult;
import network.unique.model.AllowedResponse;
import network.unique.model.CollectionInfoWithSchemaResponse;
import network.unique.model.CollectionPropertiesResponse;
import network.unique.model.ConfirmSponsorshipBody;
import network.unique.model.CreateCollectionBody;
import network.unique.model.DeleteCollectionPropertiesBody;
import network.unique.model.DestroyCollectionBody;
import network.unique.model.EffectiveCollectionLimitsResponse;
import network.unique.model.GetCollectionTokensResponse;
import network.unique.model.GetStatsResponse;
import network.unique.model.LastTokenIdResultDto;
import network.unique.model.NextSponsoredResponse;
import network.unique.model.PropertyPermissionsResponse;
import network.unique.model.RemoveCollectionAdminBody;
import network.unique.model.RemoveFromAllowListBody;
import network.unique.model.RemoveSponsorshipBody;
import network.unique.model.SetCollectionLimitsBody;
import network.unique.model.SetCollectionPermissionsBody;
import network.unique.model.SetCollectionPropertiesBody;
import network.unique.model.SetPropertyPermissionsBody;
import network.unique.model.SetSponsorshipBody;
import network.unique.model.SetTransfersEnabledBody;
import network.unique.model.SignerWrapper;
import network.unique.model.TotalSupplyResponse;
import network.unique.model.TransferCollectionBody;
import network.unique.service.CollectionService;
import network.unique.service.MutationService;
import network.unique.service.impl.collection.AddCollectionAdminMutationServiceImpl;
import network.unique.service.impl.collection.AddToAllowListMutationServiceImpl;
import network.unique.service.impl.collection.ConfirmSponsorshipMutationServiceImpl;
import network.unique.service.impl.collection.CreateCollectionMutationServiceImpl;
import network.unique.service.impl.collection.DeleteCollectionPropertiesMutationServiceImpl;
import network.unique.service.impl.collection.DestroyCollectionMutationServiceImpl;
import network.unique.service.impl.collection.RemoveCollectionAdminMutationServiceImpl;
import network.unique.service.impl.collection.RemoveFromAllowListMutationServiceImpl;
import network.unique.service.impl.collection.RemoveSponsorshipMutationServiceImpl;
import network.unique.service.impl.collection.SetCollectionLimitsMutationServiceImpl;
import network.unique.service.impl.collection.SetCollectionPermissionsMutationServiceImpl;
import network.unique.service.impl.collection.SetCollectionPropertiesMutationServiceImpl;
import network.unique.service.impl.collection.SetPropertyPermissionsMutationServiceImpl;
import network.unique.service.impl.collection.SetSponsorshipMutationServiceImpl;
import network.unique.service.impl.collection.SetTransfersEnabledMutationServiceImpl;
import network.unique.service.impl.collection.TransferCollectionMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J \u00103\u001a\u0002042\u0006\u0010.\u001a\u00020/2\u0006\u00105\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u00106\u001a\u0002072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J(\u00108\u001a\u0002092\u0006\u0010.\u001a\u00020/2\u0006\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J&\u0010<\u001a\u00020=2\u0006\u0010.\u001a\u00020/2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050?2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u0010@\u001a\u00020A2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0016J\u0018\u0010H\u001a\u00020I2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u0010J\u001a\u00020K2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00170\bH\u0016J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00190\bH\u0016J\u000e\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001b0\bH\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001d0\bH\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001f0\bH\u0016J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020!0\bH\u0016J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020#0\bH\u0016J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020%0\bH\u0016J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020'0\bH\u0016J\u0010\u0010U\u001a\u00020V2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0018\u0010W\u001a\u00020X2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020)0\bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lnetwork/unique/service/impl/CollectionServiceImpl;", "Lnetwork/unique/service/CollectionService;", "signerWrapper", "Lnetwork/unique/model/SignerWrapper;", "basePath", "", "(Lnetwork/unique/model/SignerWrapper;Ljava/lang/String;)V", "addCollectionAdminMutationService", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/AddCollectionAdminBody;", "addToAllowLIstMutationService", "Lnetwork/unique/model/AddToAllowListBody;", "api", "Lnetwork/unique/api/CollectionsApi;", "confirmSponsorshipMutationService", "Lnetwork/unique/model/ConfirmSponsorshipBody;", "createCollectionMutationService", "Lnetwork/unique/model/CreateCollectionBody;", "deleteCollectionPropertiesMutationService", "Lnetwork/unique/model/DeleteCollectionPropertiesBody;", "destroyCollectionMutationService", "Lnetwork/unique/model/DestroyCollectionBody;", "removeCollectionAdminMutationService", "Lnetwork/unique/model/RemoveCollectionAdminBody;", "removeFromAllowListMutationService", "Lnetwork/unique/model/RemoveFromAllowListBody;", "removeSponsorshipMutationService", "Lnetwork/unique/model/RemoveSponsorshipBody;", "setCollectionLimitsMutationService", "Lnetwork/unique/model/SetCollectionLimitsBody;", "setCollectionPermissionsMutationService", "Lnetwork/unique/model/SetCollectionPermissionsBody;", "setCollectionPropertiesMutationService", "Lnetwork/unique/model/SetCollectionPropertiesBody;", "setPropertyPermissionMutationService", "Lnetwork/unique/model/SetPropertyPermissionsBody;", "setSponsorshipMutationService", "Lnetwork/unique/model/SetSponsorshipBody;", "setTransfersEnabledMutationService", "Lnetwork/unique/model/SetTransfersEnabledBody;", "transferCollectionMutationService", "Lnetwork/unique/model/TransferCollectionBody;", "getAddCollectionAdminMutationService", "getAddToAllowListMutationService", "getCollectionAdmins", "Lnetwork/unique/model/AdminlistResponse;", "collectionId", "Ljava/math/BigDecimal;", "at", "getCollectionAllowList", "Lnetwork/unique/model/AllowListBodyResult;", "getCollectionAllowed", "Lnetwork/unique/model/AllowedResponse;", "account", "getCollectionLastTokenId", "Lnetwork/unique/model/LastTokenIdResultDto;", "getCollectionNextSponsored", "Lnetwork/unique/model/NextSponsoredResponse;", "address", "tokenId", "getCollectionPropertyPermissions", "Lnetwork/unique/model/PropertyPermissionsResponse;", "propertyKeys", "", "getCollectionTokens", "Lnetwork/unique/model/GetCollectionTokensResponse;", "getCollections", "Lnetwork/unique/model/CollectionInfoWithSchemaResponse;", "getConfirmSponsorshipMutationService", "getCreateCollectionMutationService", "getDeleteCollectionPropertiesMutationService", "getDestroyCollectionMutationService", "getLimits", "Lnetwork/unique/model/EffectiveCollectionLimitsResponse;", "getProperties", "Lnetwork/unique/model/CollectionPropertiesResponse;", "getRemoveCollectionAdminMutationService", "getRemoveFromAllowListMutationService", "getRemoveSponsorshipMutationService", "getSetCollectionLimitsMutationService", "getSetCollectionPermissionsMutationService", "getSetCollectionPropertiesMutationService", "getSetPropertyPermissionsMutationService", "getSetSponsorshipMutationService", "getSetTransfersEnabledMutationService", "getStats", "Lnetwork/unique/model/GetStatsResponse;", "getTotalSupply", "Lnetwork/unique/model/TotalSupplyResponse;", "getTransferCollectionMutationService", "unique-sdk"})
public final class CollectionServiceImpl
implements CollectionService {
    @NotNull
    private final CollectionsApi api;
    @NotNull
    private final MutationService<AddCollectionAdminBody> addCollectionAdminMutationService;
    @NotNull
    private final MutationService<AddToAllowListBody> addToAllowLIstMutationService;
    @NotNull
    private final MutationService<ConfirmSponsorshipBody> confirmSponsorshipMutationService;
    @NotNull
    private final MutationService<CreateCollectionBody> createCollectionMutationService;
    @NotNull
    private final MutationService<DeleteCollectionPropertiesBody> deleteCollectionPropertiesMutationService;
    @NotNull
    private final MutationService<DestroyCollectionBody> destroyCollectionMutationService;
    @NotNull
    private final MutationService<RemoveCollectionAdminBody> removeCollectionAdminMutationService;
    @NotNull
    private final MutationService<RemoveFromAllowListBody> removeFromAllowListMutationService;
    @NotNull
    private final MutationService<RemoveSponsorshipBody> removeSponsorshipMutationService;
    @NotNull
    private final MutationService<SetCollectionLimitsBody> setCollectionLimitsMutationService;
    @NotNull
    private final MutationService<SetCollectionPermissionsBody> setCollectionPermissionsMutationService;
    @NotNull
    private final MutationService<SetCollectionPropertiesBody> setCollectionPropertiesMutationService;
    @NotNull
    private final MutationService<SetPropertyPermissionsBody> setPropertyPermissionMutationService;
    @NotNull
    private final MutationService<SetSponsorshipBody> setSponsorshipMutationService;
    @NotNull
    private final MutationService<SetTransfersEnabledBody> setTransfersEnabledMutationService;
    @NotNull
    private final MutationService<TransferCollectionBody> transferCollectionMutationService;

    public CollectionServiceImpl(@NotNull SignerWrapper signerWrapper, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)signerWrapper, (String)"signerWrapper");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new CollectionsApi(basePath, null, 2, null);
        this.addCollectionAdminMutationService = new AddCollectionAdminMutationServiceImpl(signerWrapper, basePath);
        this.addToAllowLIstMutationService = new AddToAllowListMutationServiceImpl(signerWrapper, basePath);
        this.confirmSponsorshipMutationService = new ConfirmSponsorshipMutationServiceImpl(signerWrapper, basePath);
        this.createCollectionMutationService = new CreateCollectionMutationServiceImpl(signerWrapper, basePath);
        this.deleteCollectionPropertiesMutationService = new DeleteCollectionPropertiesMutationServiceImpl(signerWrapper, basePath);
        this.destroyCollectionMutationService = new DestroyCollectionMutationServiceImpl(signerWrapper, basePath);
        this.removeCollectionAdminMutationService = new RemoveCollectionAdminMutationServiceImpl(signerWrapper, basePath);
        this.removeFromAllowListMutationService = new RemoveFromAllowListMutationServiceImpl(signerWrapper, basePath);
        this.removeSponsorshipMutationService = new RemoveSponsorshipMutationServiceImpl(signerWrapper, basePath);
        this.setCollectionLimitsMutationService = new SetCollectionLimitsMutationServiceImpl(signerWrapper, basePath);
        this.setCollectionPermissionsMutationService = new SetCollectionPermissionsMutationServiceImpl(signerWrapper, basePath);
        this.setCollectionPropertiesMutationService = new SetCollectionPropertiesMutationServiceImpl(signerWrapper, basePath);
        this.setPropertyPermissionMutationService = new SetPropertyPermissionsMutationServiceImpl(signerWrapper, basePath);
        this.setSponsorshipMutationService = new SetSponsorshipMutationServiceImpl(signerWrapper, basePath);
        this.setTransfersEnabledMutationService = new SetTransfersEnabledMutationServiceImpl(signerWrapper, basePath);
        this.transferCollectionMutationService = new TransferCollectionMutationServiceImpl(signerWrapper, basePath);
    }

    @Override
    @NotNull
    public CollectionInfoWithSchemaResponse getCollections(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerGetCollection(collectionId, at);
    }

    @Override
    @NotNull
    public GetStatsResponse getStats(@NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerStats(at);
    }

    @Override
    @NotNull
    public EffectiveCollectionLimitsResponse getLimits(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerEffectiveCollectionLimits(collectionId, at);
    }

    @Override
    @NotNull
    public CollectionPropertiesResponse getProperties(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerCollectionProperties(collectionId, at);
    }

    @Override
    @NotNull
    public GetCollectionTokensResponse getCollectionTokens(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerCollectionTokens(collectionId, at);
    }

    @Override
    @NotNull
    public PropertyPermissionsResponse getCollectionPropertyPermissions(@NotNull BigDecimal collectionId, @NotNull List<String> propertyKeys, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter(propertyKeys, (String)"propertyKeys");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerPropertyPermissions(collectionId, propertyKeys, at);
    }

    @Override
    @NotNull
    public NextSponsoredResponse getCollectionNextSponsored(@NotNull BigDecimal collectionId, @NotNull String address, @NotNull BigDecimal tokenId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerNextSponsored(collectionId, address, tokenId, at);
    }

    @Override
    @NotNull
    public LastTokenIdResultDto getCollectionLastTokenId(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerLastTokenId(collectionId, at);
    }

    @Override
    @NotNull
    public AllowListBodyResult getCollectionAllowList(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerAllowList(collectionId, at);
    }

    @Override
    @NotNull
    public AllowedResponse getCollectionAllowed(@NotNull BigDecimal collectionId, @NotNull String account, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerAllowed(collectionId, account, at);
    }

    @Override
    @NotNull
    public AdminlistResponse getCollectionAdmins(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerAdmins(collectionId, at);
    }

    @Override
    @NotNull
    public TotalSupplyResponse getTotalSupply(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.collectionControllerTotalSupply(collectionId, at);
    }

    @Override
    @NotNull
    public MutationService<AddCollectionAdminBody> getAddCollectionAdminMutationService() {
        return this.addCollectionAdminMutationService;
    }

    @Override
    @NotNull
    public MutationService<AddToAllowListBody> getAddToAllowListMutationService() {
        return this.addToAllowLIstMutationService;
    }

    @Override
    @NotNull
    public MutationService<ConfirmSponsorshipBody> getConfirmSponsorshipMutationService() {
        return this.confirmSponsorshipMutationService;
    }

    @Override
    @NotNull
    public MutationService<CreateCollectionBody> getCreateCollectionMutationService() {
        return this.createCollectionMutationService;
    }

    @Override
    @NotNull
    public MutationService<DestroyCollectionBody> getDestroyCollectionMutationService() {
        return this.destroyCollectionMutationService;
    }

    @Override
    @NotNull
    public MutationService<DeleteCollectionPropertiesBody> getDeleteCollectionPropertiesMutationService() {
        return this.deleteCollectionPropertiesMutationService;
    }

    @Override
    @NotNull
    public MutationService<RemoveCollectionAdminBody> getRemoveCollectionAdminMutationService() {
        return this.removeCollectionAdminMutationService;
    }

    @Override
    @NotNull
    public MutationService<RemoveFromAllowListBody> getRemoveFromAllowListMutationService() {
        return this.removeFromAllowListMutationService;
    }

    @Override
    @NotNull
    public MutationService<RemoveSponsorshipBody> getRemoveSponsorshipMutationService() {
        return this.removeSponsorshipMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetCollectionLimitsBody> getSetCollectionLimitsMutationService() {
        return this.setCollectionLimitsMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetCollectionPermissionsBody> getSetCollectionPermissionsMutationService() {
        return this.setCollectionPermissionsMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetCollectionPropertiesBody> getSetCollectionPropertiesMutationService() {
        return this.setCollectionPropertiesMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetPropertyPermissionsBody> getSetPropertyPermissionsMutationService() {
        return this.setPropertyPermissionMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetSponsorshipBody> getSetSponsorshipMutationService() {
        return this.setSponsorshipMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetTransfersEnabledBody> getSetTransfersEnabledMutationService() {
        return this.setTransfersEnabledMutationService;
    }

    @Override
    @NotNull
    public MutationService<TransferCollectionBody> getTransferCollectionMutationService() {
        return this.transferCollectionMutationService;
    }
}

