/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import network.unique.api.ExtrinsicApi;
import network.unique.model.ExtrinsicResultResponse;
import network.unique.model.ExtrinsicsControllerCalculateFeeRequest;
import network.unique.model.FeeResponse;
import network.unique.model.GetExtrinsicResponse;
import network.unique.model.SignTxResultResponse;
import network.unique.model.SubmitResultResponse;
import network.unique.model.SubmitTxBody;
import network.unique.model.TxBuildBody;
import network.unique.model.UnsignedTxPayloadBody;
import network.unique.model.UnsignedTxPayloadResponse;
import network.unique.model.VerificationResultResponse;
import network.unique.service.ExtrinsicService;
import network.unique.service.impl.ExtrinsicServiceImpl;
import network.unique.signer.CryptoScheme;
import network.unique.signer.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnetwork/unique/service/impl/ExtrinsicServiceImpl;", "Lnetwork/unique/service/ExtrinsicService;", "basePath", "", "(Ljava/lang/String;)V", "api", "Lnetwork/unique/api/ExtrinsicApi;", "buildTx", "Lnetwork/unique/model/UnsignedTxPayloadResponse;", "body", "Lnetwork/unique/model/TxBuildBody;", "calculateFee", "Lnetwork/unique/model/FeeResponse;", "Lnetwork/unique/model/ExtrinsicsControllerCalculateFeeRequest;", "getExtrinsic", "Lnetwork/unique/model/GetExtrinsicResponse;", "blockHashOrNumber", "extrinsicHash", "getExtrinsicStatus", "Lnetwork/unique/model/ExtrinsicResultResponse;", "hash", "signTx", "Lnetwork/unique/model/SignTxResultResponse;", "Lnetwork/unique/model/UnsignedTxPayloadBody;", "seed", "submit", "Lnetwork/unique/model/SubmitResultResponse;", "Lnetwork/unique/model/SubmitTxBody;", "toByteArray", "", "data", "verifySign", "Lnetwork/unique/model/VerificationResultResponse;", "unique-sdk"})
public final class ExtrinsicServiceImpl
implements ExtrinsicService {
    @NotNull
    private final ExtrinsicApi api;

    public ExtrinsicServiceImpl(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new ExtrinsicApi(basePath, null, 2, null);
    }

    @Override
    @NotNull
    public UnsignedTxPayloadResponse buildTx(@NotNull TxBuildBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.api.extrinsicsControllerBuildTx(body);
    }

    @Override
    @NotNull
    public SignTxResultResponse signTx(@NotNull UnsignedTxPayloadBody body, @NotNull String seed) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Pair keyPair = Pair.fromSuri((CryptoScheme)CryptoScheme.Sr25519, (String)seed, null);
        String string = body.getSignerPayloadRaw().getData().substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        byte[] byArray = keyPair.sign(this.toByteArray(string));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.sign(toByteArray\u2026adRaw.data.substring(2)))");
        String signature2 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)signTx.signature.1.INSTANCE, (int)30, null);
        return new SignTxResultResponse("0x01" + signature2, SignTxResultResponse.SignatureType.sr25519);
    }

    @Override
    @NotNull
    public VerificationResultResponse verifySign(@NotNull SubmitTxBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.api.extrinsicsControllerVerifySign(body);
    }

    @Override
    @NotNull
    public SubmitResultResponse submit(@NotNull SubmitTxBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.api.extrinsicsControllerSubmitTx(body);
    }

    @Override
    @NotNull
    public FeeResponse calculateFee(@NotNull ExtrinsicsControllerCalculateFeeRequest body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.api.extrinsicsControllerCalculateFee(body);
    }

    @Override
    @NotNull
    public ExtrinsicResultResponse getExtrinsicStatus(@NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.api.extrinsicsControllerGetStatus(hash);
    }

    @Override
    @NotNull
    public GetExtrinsicResponse getExtrinsic(@NotNull String blockHashOrNumber, @NotNull String extrinsicHash) {
        Intrinsics.checkNotNullParameter((Object)blockHashOrNumber, (String)"blockHashOrNumber");
        Intrinsics.checkNotNullParameter((Object)extrinsicHash, (String)"extrinsicHash");
        return this.api.extrinsicsControllerGet(blockHashOrNumber, extrinsicHash);
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] toByteArray(String data) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)data, (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }
}

