/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.FungibleApi;
import network.unique.model.AddTokensArgsDto;
import network.unique.model.BalanceResponse;
import network.unique.model.CreateFungibleCollectionRequest;
import network.unique.model.FungibleCollectionInfoDto;
import network.unique.model.SignerWrapper;
import network.unique.model.TransferTokensArgsDto;
import network.unique.service.FungibleService;
import network.unique.service.MutationService;
import network.unique.service.impl.fungible.AddTokensMutationServiceImpl;
import network.unique.service.impl.fungible.CreateFungibleCollectionMutationServiceImpl;
import network.unique.service.impl.fungible.TransferTokensMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnetwork/unique/service/impl/FungibleServiceImpl;", "Lnetwork/unique/service/FungibleService;", "signerWrapper", "Lnetwork/unique/model/SignerWrapper;", "basePath", "", "(Lnetwork/unique/model/SignerWrapper;Ljava/lang/String;)V", "addTokensMutationService", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/AddTokensArgsDto;", "api", "Lnetwork/unique/api/FungibleApi;", "createFungibleCollectionMutationService", "Lnetwork/unique/model/CreateFungibleCollectionRequest;", "transferTokensMutationService", "Lnetwork/unique/model/TransferTokensArgsDto;", "getAddTokensMutationService", "getBalance", "Lnetwork/unique/model/BalanceResponse;", "collectionId", "Ljava/math/BigDecimal;", "address", "at", "getCreateFungibleCollectionMutationService", "getFungibleCollectionInfo", "Lnetwork/unique/model/FungibleCollectionInfoDto;", "getTransferTokensMutationService", "unique-sdk"})
public final class FungibleServiceImpl
implements FungibleService {
    @NotNull
    private final FungibleApi api;
    @NotNull
    private final MutationService<AddTokensArgsDto> addTokensMutationService;
    @NotNull
    private final MutationService<CreateFungibleCollectionRequest> createFungibleCollectionMutationService;
    @NotNull
    private final MutationService<TransferTokensArgsDto> transferTokensMutationService;

    public FungibleServiceImpl(@NotNull SignerWrapper signerWrapper, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)signerWrapper, (String)"signerWrapper");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new FungibleApi(basePath, null, 2, null);
        this.addTokensMutationService = new AddTokensMutationServiceImpl(signerWrapper, basePath);
        this.createFungibleCollectionMutationService = new CreateFungibleCollectionMutationServiceImpl(signerWrapper, basePath);
        this.transferTokensMutationService = new TransferTokensMutationServiceImpl(signerWrapper, basePath);
    }

    @Override
    @NotNull
    public FungibleCollectionInfoDto getFungibleCollectionInfo(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.fungibleControllerGetCollection(collectionId, at);
    }

    @Override
    @NotNull
    public BalanceResponse getBalance(@NotNull BigDecimal collectionId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.fungibleControllerGetBalance(address, collectionId, at);
    }

    @Override
    @NotNull
    public MutationService<AddTokensArgsDto> getAddTokensMutationService() {
        return this.addTokensMutationService;
    }

    @Override
    @NotNull
    public MutationService<CreateFungibleCollectionRequest> getCreateFungibleCollectionMutationService() {
        return this.createFungibleCollectionMutationService;
    }

    @Override
    @NotNull
    public MutationService<TransferTokensArgsDto> getTransferTokensMutationService() {
        return this.transferTokensMutationService;
    }
}

