/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.IpfsApi;
import network.unique.model.IpfsUploadResponse;
import network.unique.service.IPFSService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnetwork/unique/service/impl/IPFSServiceImpl;", "Lnetwork/unique/service/IPFSService;", "basePath", "", "(Ljava/lang/String;)V", "api", "Lnetwork/unique/api/IpfsApi;", "addFiles", "Lnetwork/unique/model/IpfsUploadResponse;", "files", "", "Ljava/io/File;", "cid", "uploadFile", "file", "uploadFiles", "unique-sdk"})
public final class IPFSServiceImpl
implements IPFSService {
    @NotNull
    private final IpfsApi api;

    public IPFSServiceImpl(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new IpfsApi(basePath, null, 2, null);
    }

    @Override
    @NotNull
    public IpfsUploadResponse uploadFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.api.ipfsControllerUploadFile(file);
    }

    @Override
    @NotNull
    public IpfsUploadResponse uploadFiles(@NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return this.api.ipfsControllerUploadFiles(files);
    }

    @Override
    @NotNull
    public IpfsUploadResponse addFiles(@NotNull List<? extends File> files, @NotNull String cid) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        return this.api.ipfsControllerAddFiles(files, cid);
    }
}

