/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.TokensApi;
import network.unique.model.AccountTokensResponse;
import network.unique.model.AllowanceResultResponse;
import network.unique.model.ApproveTokenBody;
import network.unique.model.BurnTokenBody;
import network.unique.model.CreateMultipleTokensBody;
import network.unique.model.CreateTokenBody;
import network.unique.model.DeleteTokenPropertiesBody;
import network.unique.model.GetBundleResponse;
import network.unique.model.IsBundleResponse;
import network.unique.model.NestTokenBody;
import network.unique.model.SetTokenPropertiesBody;
import network.unique.model.SignerWrapper;
import network.unique.model.TokenBalanceResponse;
import network.unique.model.TokenByIdResponse;
import network.unique.model.TokenChildrenResponse;
import network.unique.model.TokenExistsResponse;
import network.unique.model.TokenOwnerResponse;
import network.unique.model.TokenParentResponse;
import network.unique.model.TokenPropertiesResponse;
import network.unique.model.TopmostTokenOwnerResponse;
import network.unique.model.TransferTokenBody;
import network.unique.model.UnnestTokenBody;
import network.unique.service.MutationService;
import network.unique.service.TokenService;
import network.unique.service.impl.token.ApproveTokenMutationServiceImpl;
import network.unique.service.impl.token.BurnTokenMutationServiceImpl;
import network.unique.service.impl.token.CreateMultipleTokensMutationServiceImpl;
import network.unique.service.impl.token.CreateTokenMutationServiceImpl;
import network.unique.service.impl.token.DeleteTokenPropertiesMutationServiceImpl;
import network.unique.service.impl.token.NestTokenMutationServiceImpl;
import network.unique.service.impl.token.SetTokenPropertiesMutationServiceImpl;
import network.unique.service.impl.token.TransferTokenMutationServiceImpl;
import network.unique.service.impl.token.UnnestTokenMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\nH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J(\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u00100\u001a\u0002012\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u00102\u001a\u0002032\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u00104\u001a\u0002052\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u00106\u001a\u0002072\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u00108\u001a\u0002092\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190\nH\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0\nH\u0016J0\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010@\u001a\u00020A2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010B\u001a\u00020C2\u0006\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lnetwork/unique/service/impl/TokenServiceImpl;", "Lnetwork/unique/service/TokenService;", "signerWrapper", "Lnetwork/unique/model/SignerWrapper;", "basePath", "", "(Lnetwork/unique/model/SignerWrapper;Ljava/lang/String;)V", "api", "Lnetwork/unique/api/TokensApi;", "approveTokenMutationService", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/ApproveTokenBody;", "burnTokenMutationService", "Lnetwork/unique/model/BurnTokenBody;", "createMultipleTokensMutationService", "Lnetwork/unique/model/CreateMultipleTokensBody;", "createTokenMutationService", "Lnetwork/unique/model/CreateTokenBody;", "deleteTokenPropertiesMutationService", "Lnetwork/unique/model/DeleteTokenPropertiesBody;", "nestTokenMutationService", "Lnetwork/unique/model/NestTokenBody;", "setTokenPropertiesMutationService", "Lnetwork/unique/model/SetTokenPropertiesBody;", "transferTokenMutationService", "Lnetwork/unique/model/TransferTokenBody;", "unnsetTokenMutationService", "Lnetwork/unique/model/UnnestTokenBody;", "getAccountTokens", "Lnetwork/unique/model/AccountTokensResponse;", "address", "collectionId", "Ljava/math/BigDecimal;", "at", "getApproveTokenMutationService", "getBurnTokenMutationService", "getCreateMultipleTokensMutationService", "getCreateTokenMutationService", "getDeleteTokenPropertiesMutationService", "getNestTokenMutationService", "getSetTokenPropertiesMutationService", "getToken", "Lnetwork/unique/model/TokenByIdResponse;", "tokenId", "getTokenBalance", "Lnetwork/unique/model/TokenBalanceResponse;", "getTokenBundle", "Lnetwork/unique/model/GetBundleResponse;", "getTokenChildren", "Lnetwork/unique/model/TokenChildrenResponse;", "getTokenOwner", "Lnetwork/unique/model/TokenOwnerResponse;", "getTokenParent", "Lnetwork/unique/model/TokenParentResponse;", "getTokenProperties", "Lnetwork/unique/model/TokenPropertiesResponse;", "getTopmostTokenOwner", "Lnetwork/unique/model/TopmostTokenOwnerResponse;", "getTransferTokenMutationService", "getUnnestTokenMutationService", "tokenIsAllowed", "Lnetwork/unique/model/AllowanceResultResponse;", "from", "to", "tokenIsBundle", "Lnetwork/unique/model/IsBundleResponse;", "tokenIsExists", "Lnetwork/unique/model/TokenExistsResponse;", "unique-sdk"})
public final class TokenServiceImpl
implements TokenService {
    @NotNull
    private final TokensApi api;
    @NotNull
    private final MutationService<ApproveTokenBody> approveTokenMutationService;
    @NotNull
    private final MutationService<BurnTokenBody> burnTokenMutationService;
    @NotNull
    private final MutationService<CreateMultipleTokensBody> createMultipleTokensMutationService;
    @NotNull
    private final MutationService<CreateTokenBody> createTokenMutationService;
    @NotNull
    private final MutationService<DeleteTokenPropertiesBody> deleteTokenPropertiesMutationService;
    @NotNull
    private final MutationService<NestTokenBody> nestTokenMutationService;
    @NotNull
    private final MutationService<SetTokenPropertiesBody> setTokenPropertiesMutationService;
    @NotNull
    private final MutationService<TransferTokenBody> transferTokenMutationService;
    @NotNull
    private final MutationService<UnnestTokenBody> unnsetTokenMutationService;

    public TokenServiceImpl(@NotNull SignerWrapper signerWrapper, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)signerWrapper, (String)"signerWrapper");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new TokensApi(basePath, null, 2, null);
        this.approveTokenMutationService = new ApproveTokenMutationServiceImpl(signerWrapper, basePath);
        this.burnTokenMutationService = new BurnTokenMutationServiceImpl(signerWrapper, basePath);
        this.createMultipleTokensMutationService = new CreateMultipleTokensMutationServiceImpl(signerWrapper, basePath);
        this.createTokenMutationService = new CreateTokenMutationServiceImpl(signerWrapper, basePath);
        this.deleteTokenPropertiesMutationService = new DeleteTokenPropertiesMutationServiceImpl(signerWrapper, basePath);
        this.nestTokenMutationService = new NestTokenMutationServiceImpl(signerWrapper, basePath);
        this.setTokenPropertiesMutationService = new SetTokenPropertiesMutationServiceImpl(signerWrapper, basePath);
        this.transferTokenMutationService = new TransferTokenMutationServiceImpl(signerWrapper, basePath);
        this.unnsetTokenMutationService = new UnnestTokenMutationServiceImpl(signerWrapper, basePath);
    }

    @Override
    @NotNull
    public TokenByIdResponse getToken(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerGetTokenNew(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TokenChildrenResponse getTokenChildren(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerTokenChildren(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TokenParentResponse getTokenParent(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerTokenParent(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TokenOwnerResponse getTokenOwner(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerTokenOwner(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TopmostTokenOwnerResponse getTopmostTokenOwner(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerTopmostTokenOwner(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public IsBundleResponse tokenIsBundle(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerIsBundle(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public GetBundleResponse getTokenBundle(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerGetBundle(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public TokenPropertiesResponse getTokenProperties(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerTokenProperties(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public AccountTokensResponse getAccountTokens(@NotNull String address, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerGetAccountTokens(address, collectionId, at);
    }

    @Override
    @NotNull
    public TokenExistsResponse tokenIsExists(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerGetTokensExists(collectionId, tokenId, at);
    }

    @Override
    @NotNull
    public AllowanceResultResponse tokenIsAllowed(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String from, @NotNull String to, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerAllowance(collectionId, tokenId, from, to, at);
    }

    @Override
    @NotNull
    public TokenBalanceResponse getTokenBalance(@NotNull BigDecimal tokenId, @NotNull BigDecimal collectionId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.newTokenControllerGetBalance(collectionId, tokenId, address, at);
    }

    @Override
    @NotNull
    public MutationService<ApproveTokenBody> getApproveTokenMutationService() {
        return this.approveTokenMutationService;
    }

    @Override
    @NotNull
    public MutationService<BurnTokenBody> getBurnTokenMutationService() {
        return this.burnTokenMutationService;
    }

    @Override
    @NotNull
    public MutationService<CreateMultipleTokensBody> getCreateMultipleTokensMutationService() {
        return this.createMultipleTokensMutationService;
    }

    @Override
    @NotNull
    public MutationService<CreateTokenBody> getCreateTokenMutationService() {
        return this.createTokenMutationService;
    }

    @Override
    @NotNull
    public MutationService<DeleteTokenPropertiesBody> getDeleteTokenPropertiesMutationService() {
        return this.deleteTokenPropertiesMutationService;
    }

    @Override
    @NotNull
    public MutationService<NestTokenBody> getNestTokenMutationService() {
        return this.nestTokenMutationService;
    }

    @Override
    @NotNull
    public MutationService<SetTokenPropertiesBody> getSetTokenPropertiesMutationService() {
        return this.setTokenPropertiesMutationService;
    }

    @Override
    @NotNull
    public MutationService<TransferTokenBody> getTransferTokenMutationService() {
        return this.transferTokenMutationService;
    }

    @Override
    @NotNull
    public MutationService<UnnestTokenBody> getUnnestTokenMutationService() {
        return this.unnsetTokenMutationService;
    }
}

