/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package network.unique.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import network.unique.model.AccountTokensResponse
import network.unique.model.AllowanceResultResponse
import network.unique.model.ApproveDefaultResponse
import network.unique.model.ApproveRequest
import network.unique.model.BurnTokenDefaultResponse
import network.unique.model.BurnTokenRequest
import network.unique.model.CreateMultipleTokensMutationRequest
import network.unique.model.CreateNewTokenMutationDefaultResponse
import network.unique.model.CreateNewTokenMutationRequest
import network.unique.model.DeleteTokenPropertiesDefaultResponse
import network.unique.model.DeleteTokenPropertiesRequest
import network.unique.model.GetBundleResponse
import network.unique.model.IsBundleResponse
import network.unique.model.NestTokenDefaultResponse
import network.unique.model.NestTokenRequest
import network.unique.model.SetTokenPropertiesDefaultResponse
import network.unique.model.SetTokenPropertiesRequest
import network.unique.model.TokenBalanceResponse
import network.unique.model.TokenByIdResponse
import network.unique.model.TokenChildrenResponse
import network.unique.model.TokenExistsResponse
import network.unique.model.TokenOwnerResponse
import network.unique.model.TokenParentResponse
import network.unique.model.TokenPropertiesResponse
import network.unique.model.TopmostTokenOwnerResponse
import network.unique.model.TransferTokenDefaultResponse
import network.unique.model.TransferTokenRequest
import network.unique.model.UnnestTokenDefaultResponse
import network.unique.model.UnnestTokenRequest

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class TokensApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost")
        }
    }

    /**
     * enum for parameter use
     */
     enum class Use_approve(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param approveRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApproveDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun approve(approveRequest: ApproveRequest, use: Use_approve? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : ApproveDefaultResponse {
        val localVarResponse = approveWithHttpInfo(approveRequest = approveRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ApproveDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param approveRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<ApproveDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun approveWithHttpInfo(approveRequest: ApproveRequest, use: Use_approve?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<ApproveDefaultResponse?> {
        val localVariableConfig = approveRequestConfig(approveRequest = approveRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<ApproveRequest, ApproveDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation approve
     *
     * @param approveRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun approveRequestConfig(approveRequest: ApproveRequest, use: Use_approve?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<ApproveRequest> {
        val localVariableBody = approveRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens/approve",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_burnToken(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param burnTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return BurnTokenDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun burnToken(burnTokenRequest: BurnTokenRequest, use: Use_burnToken? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : BurnTokenDefaultResponse {
        val localVarResponse = burnTokenWithHttpInfo(burnTokenRequest = burnTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BurnTokenDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param burnTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<BurnTokenDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun burnTokenWithHttpInfo(burnTokenRequest: BurnTokenRequest, use: Use_burnToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<BurnTokenDefaultResponse?> {
        val localVariableConfig = burnTokenRequestConfig(burnTokenRequest = burnTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<BurnTokenRequest, BurnTokenDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation burnToken
     *
     * @param burnTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun burnTokenRequestConfig(burnTokenRequest: BurnTokenRequest, use: Use_burnToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<BurnTokenRequest> {
        val localVariableBody = burnTokenRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/v1/tokens",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_createMultipleTokensMutation(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param createMultipleTokensMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return CreateNewTokenMutationDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createMultipleTokensMutation(createMultipleTokensMutationRequest: CreateMultipleTokensMutationRequest, use: Use_createMultipleTokensMutation? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : CreateNewTokenMutationDefaultResponse {
        val localVarResponse = createMultipleTokensMutationWithHttpInfo(createMultipleTokensMutationRequest = createMultipleTokensMutationRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CreateNewTokenMutationDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param createMultipleTokensMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<CreateNewTokenMutationDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun createMultipleTokensMutationWithHttpInfo(createMultipleTokensMutationRequest: CreateMultipleTokensMutationRequest, use: Use_createMultipleTokensMutation?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<CreateNewTokenMutationDefaultResponse?> {
        val localVariableConfig = createMultipleTokensMutationRequestConfig(createMultipleTokensMutationRequest = createMultipleTokensMutationRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<CreateMultipleTokensMutationRequest, CreateNewTokenMutationDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation createMultipleTokensMutation
     *
     * @param createMultipleTokensMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun createMultipleTokensMutationRequestConfig(createMultipleTokensMutationRequest: CreateMultipleTokensMutationRequest, use: Use_createMultipleTokensMutation?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<CreateMultipleTokensMutationRequest> {
        val localVariableBody = createMultipleTokensMutationRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens/create-multiple",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_createNewTokenMutation(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param createNewTokenMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return CreateNewTokenMutationDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createNewTokenMutation(createNewTokenMutationRequest: CreateNewTokenMutationRequest, use: Use_createNewTokenMutation? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : CreateNewTokenMutationDefaultResponse {
        val localVarResponse = createNewTokenMutationWithHttpInfo(createNewTokenMutationRequest = createNewTokenMutationRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CreateNewTokenMutationDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param createNewTokenMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<CreateNewTokenMutationDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun createNewTokenMutationWithHttpInfo(createNewTokenMutationRequest: CreateNewTokenMutationRequest, use: Use_createNewTokenMutation?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<CreateNewTokenMutationDefaultResponse?> {
        val localVariableConfig = createNewTokenMutationRequestConfig(createNewTokenMutationRequest = createNewTokenMutationRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<CreateNewTokenMutationRequest, CreateNewTokenMutationDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation createNewTokenMutation
     *
     * @param createNewTokenMutationRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun createNewTokenMutationRequestConfig(createNewTokenMutationRequest: CreateNewTokenMutationRequest, use: Use_createNewTokenMutation?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<CreateNewTokenMutationRequest> {
        val localVariableBody = createNewTokenMutationRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_deleteTokenProperties(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param deleteTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return DeleteTokenPropertiesDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun deleteTokenProperties(deleteTokenPropertiesRequest: DeleteTokenPropertiesRequest, use: Use_deleteTokenProperties? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : DeleteTokenPropertiesDefaultResponse {
        val localVarResponse = deleteTokenPropertiesWithHttpInfo(deleteTokenPropertiesRequest = deleteTokenPropertiesRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DeleteTokenPropertiesDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param deleteTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<DeleteTokenPropertiesDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun deleteTokenPropertiesWithHttpInfo(deleteTokenPropertiesRequest: DeleteTokenPropertiesRequest, use: Use_deleteTokenProperties?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<DeleteTokenPropertiesDefaultResponse?> {
        val localVariableConfig = deleteTokenPropertiesRequestConfig(deleteTokenPropertiesRequest = deleteTokenPropertiesRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<DeleteTokenPropertiesRequest, DeleteTokenPropertiesDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation deleteTokenProperties
     *
     * @param deleteTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun deleteTokenPropertiesRequestConfig(deleteTokenPropertiesRequest: DeleteTokenPropertiesRequest, use: Use_deleteTokenProperties?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<DeleteTokenPropertiesRequest> {
        val localVariableBody = deleteTokenPropertiesRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/v1/tokens/properties",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_nestToken(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param nestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return NestTokenDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun nestToken(nestTokenRequest: NestTokenRequest, use: Use_nestToken? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : NestTokenDefaultResponse {
        val localVarResponse = nestTokenWithHttpInfo(nestTokenRequest = nestTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NestTokenDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param nestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<NestTokenDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun nestTokenWithHttpInfo(nestTokenRequest: NestTokenRequest, use: Use_nestToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<NestTokenDefaultResponse?> {
        val localVariableConfig = nestTokenRequestConfig(nestTokenRequest = nestTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<NestTokenRequest, NestTokenDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation nestToken
     *
     * @param nestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun nestTokenRequestConfig(nestTokenRequest: NestTokenRequest, use: Use_nestToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<NestTokenRequest> {
        val localVariableBody = nestTokenRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens/nest",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param from The ss-58 encoded address
     * @param to The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return AllowanceResultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerAllowance(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, from: kotlin.String, to: kotlin.String, at: kotlin.String? = null) : AllowanceResultResponse {
        val localVarResponse = newTokenControllerAllowanceWithHttpInfo(collectionId = collectionId, tokenId = tokenId, from = from, to = to, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as AllowanceResultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param from The ss-58 encoded address
     * @param to The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return ApiResponse<AllowanceResultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerAllowanceWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, from: kotlin.String, to: kotlin.String, at: kotlin.String?) : ApiResponse<AllowanceResultResponse?> {
        val localVariableConfig = newTokenControllerAllowanceRequestConfig(collectionId = collectionId, tokenId = tokenId, from = from, to = to, at = at)

        return request<Unit, AllowanceResultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerAllowance
     *
     * @param collectionId 
     * @param tokenId 
     * @param from The ss-58 encoded address
     * @param to The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerAllowanceRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, from: kotlin.String, to: kotlin.String, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
                put("from", listOf(from.toString()))
                put("to", listOf(to.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/allowance",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @param collectionId 
     * @param at Hash of execution block (optional)
     * @return AccountTokensResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerGetAccountTokens(address: kotlin.String, collectionId: java.math.BigDecimal, at: kotlin.String? = null) : AccountTokensResponse {
        val localVarResponse = newTokenControllerGetAccountTokensWithHttpInfo(address = address, collectionId = collectionId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as AccountTokensResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @param collectionId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<AccountTokensResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerGetAccountTokensWithHttpInfo(address: kotlin.String, collectionId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<AccountTokensResponse?> {
        val localVariableConfig = newTokenControllerGetAccountTokensRequestConfig(address = address, collectionId = collectionId, at = at)

        return request<Unit, AccountTokensResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerGetAccountTokens
     *
     * @param address The ss-58 encoded address
     * @param collectionId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerGetAccountTokensRequestConfig(address: kotlin.String, collectionId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("address", listOf(address.toString()))
                put("collectionId", listOf(collectionId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/account-tokens",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param address The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return TokenBalanceResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerGetBalance(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, address: kotlin.String, at: kotlin.String? = null) : TokenBalanceResponse {
        val localVarResponse = newTokenControllerGetBalanceWithHttpInfo(collectionId = collectionId, tokenId = tokenId, address = address, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenBalanceResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param address The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenBalanceResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerGetBalanceWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, address: kotlin.String, at: kotlin.String?) : ApiResponse<TokenBalanceResponse?> {
        val localVariableConfig = newTokenControllerGetBalanceRequestConfig(collectionId = collectionId, tokenId = tokenId, address = address, at = at)

        return request<Unit, TokenBalanceResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerGetBalance
     *
     * @param collectionId 
     * @param tokenId 
     * @param address The ss-58 encoded address
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerGetBalanceRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, address: kotlin.String, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
                put("address", listOf(address.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/balance",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return GetBundleResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerGetBundle(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : GetBundleResponse {
        val localVarResponse = newTokenControllerGetBundleWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as GetBundleResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<GetBundleResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerGetBundleWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<GetBundleResponse?> {
        val localVariableConfig = newTokenControllerGetBundleRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, GetBundleResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerGetBundle
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerGetBundleRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/get-bundle",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenByIdResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerGetTokenNew(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenByIdResponse {
        val localVarResponse = newTokenControllerGetTokenNewWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenByIdResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenByIdResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerGetTokenNewWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenByIdResponse?> {
        val localVariableConfig = newTokenControllerGetTokenNewRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenByIdResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerGetTokenNew
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerGetTokenNewRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenExistsResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerGetTokensExists(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenExistsResponse {
        val localVarResponse = newTokenControllerGetTokensExistsWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenExistsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenExistsResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerGetTokensExistsWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenExistsResponse?> {
        val localVariableConfig = newTokenControllerGetTokensExistsRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenExistsResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerGetTokensExists
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerGetTokensExistsRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/exists",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return IsBundleResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerIsBundle(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : IsBundleResponse {
        val localVarResponse = newTokenControllerIsBundleWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as IsBundleResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<IsBundleResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerIsBundleWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<IsBundleResponse?> {
        val localVariableConfig = newTokenControllerIsBundleRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, IsBundleResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerIsBundle
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerIsBundleRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/is-bundle",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenChildrenResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerTokenChildren(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenChildrenResponse {
        val localVarResponse = newTokenControllerTokenChildrenWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenChildrenResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenChildrenResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerTokenChildrenWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenChildrenResponse?> {
        val localVariableConfig = newTokenControllerTokenChildrenRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenChildrenResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerTokenChildren
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerTokenChildrenRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/children",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenOwnerResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerTokenOwner(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenOwnerResponse {
        val localVarResponse = newTokenControllerTokenOwnerWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenOwnerResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenOwnerResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerTokenOwnerWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenOwnerResponse?> {
        val localVariableConfig = newTokenControllerTokenOwnerRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenOwnerResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerTokenOwner
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerTokenOwnerRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/owner",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenParentResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerTokenParent(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenParentResponse {
        val localVarResponse = newTokenControllerTokenParentWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenParentResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenParentResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerTokenParentWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenParentResponse?> {
        val localVariableConfig = newTokenControllerTokenParentRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenParentResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerTokenParent
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerTokenParentRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/parent",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TokenPropertiesResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerTokenProperties(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TokenPropertiesResponse {
        val localVarResponse = newTokenControllerTokenPropertiesWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenPropertiesResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TokenPropertiesResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerTokenPropertiesWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TokenPropertiesResponse?> {
        val localVariableConfig = newTokenControllerTokenPropertiesRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TokenPropertiesResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerTokenProperties
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerTokenPropertiesRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/properties",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return TopmostTokenOwnerResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun newTokenControllerTopmostTokenOwner(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : TopmostTokenOwnerResponse {
        val localVarResponse = newTokenControllerTopmostTokenOwnerWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TopmostTokenOwnerResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<TopmostTokenOwnerResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun newTokenControllerTopmostTokenOwnerWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<TopmostTokenOwnerResponse?> {
        val localVariableConfig = newTokenControllerTopmostTokenOwnerRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, TopmostTokenOwnerResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation newTokenControllerTopmostTokenOwner
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun newTokenControllerTopmostTokenOwnerRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/tokens/topmost-owner",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_setTokenProperties(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param setTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return SetTokenPropertiesDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun setTokenProperties(setTokenPropertiesRequest: SetTokenPropertiesRequest, use: Use_setTokenProperties? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : SetTokenPropertiesDefaultResponse {
        val localVarResponse = setTokenPropertiesWithHttpInfo(setTokenPropertiesRequest = setTokenPropertiesRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SetTokenPropertiesDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param setTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<SetTokenPropertiesDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun setTokenPropertiesWithHttpInfo(setTokenPropertiesRequest: SetTokenPropertiesRequest, use: Use_setTokenProperties?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<SetTokenPropertiesDefaultResponse?> {
        val localVariableConfig = setTokenPropertiesRequestConfig(setTokenPropertiesRequest = setTokenPropertiesRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<SetTokenPropertiesRequest, SetTokenPropertiesDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation setTokenProperties
     *
     * @param setTokenPropertiesRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun setTokenPropertiesRequestConfig(setTokenPropertiesRequest: SetTokenPropertiesRequest, use: Use_setTokenProperties?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<SetTokenPropertiesRequest> {
        val localVariableBody = setTokenPropertiesRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens/properties",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_transferToken(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param transferTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return TransferTokenDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun transferToken(transferTokenRequest: TransferTokenRequest, use: Use_transferToken? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : TransferTokenDefaultResponse {
        val localVarResponse = transferTokenWithHttpInfo(transferTokenRequest = transferTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TransferTokenDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param transferTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<TransferTokenDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun transferTokenWithHttpInfo(transferTokenRequest: TransferTokenRequest, use: Use_transferToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<TransferTokenDefaultResponse?> {
        val localVariableConfig = transferTokenRequestConfig(transferTokenRequest = transferTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<TransferTokenRequest, TransferTokenDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation transferToken
     *
     * @param transferTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun transferTokenRequestConfig(transferTokenRequest: TransferTokenRequest, use: Use_transferToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<TransferTokenRequest> {
        val localVariableBody = transferTokenRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PATCH,
            path = "/v1/tokens/transfer",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter use
     */
     enum class Use_unnestToken(val value: kotlin.String) {
         @Json(name = "Build") build("Build"),
         @Json(name = "BuildBatch") buildBatch("BuildBatch"),
         @Json(name = "Sign") sign("Sign"),
         @Json(name = "Submit") submit("Submit"),
         @Json(name = "Result") result("Result"),
         @Json(name = "GetFee") getFee("GetFee");

        override fun toString(): String {
            return value
        }
     }

    /**
     * 
     * 
     * @param unnestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return UnnestTokenDefaultResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun unnestToken(unnestTokenRequest: UnnestTokenRequest, use: Use_unnestToken? = null, withFee: kotlin.Boolean? = false, verify: kotlin.Boolean? = false, callbackUrl: kotlin.String? = null, nonce: java.math.BigDecimal? = null) : UnnestTokenDefaultResponse {
        val localVarResponse = unnestTokenWithHttpInfo(unnestTokenRequest = unnestTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as UnnestTokenDefaultResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param unnestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return ApiResponse<UnnestTokenDefaultResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun unnestTokenWithHttpInfo(unnestTokenRequest: UnnestTokenRequest, use: Use_unnestToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : ApiResponse<UnnestTokenDefaultResponse?> {
        val localVariableConfig = unnestTokenRequestConfig(unnestTokenRequest = unnestTokenRequest, use = use, withFee = withFee, verify = verify, callbackUrl = callbackUrl, nonce = nonce)

        return request<UnnestTokenRequest, UnnestTokenDefaultResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation unnestToken
     *
     * @param unnestTokenRequest 
     * @param use  (optional)
     * @param withFee  (optional, default to false)
     * @param verify  (optional, default to false)
     * @param callbackUrl  (optional)
     * @param nonce  (optional)
     * @return RequestConfig
     */
    fun unnestTokenRequestConfig(unnestTokenRequest: UnnestTokenRequest, use: Use_unnestToken?, withFee: kotlin.Boolean?, verify: kotlin.Boolean?, callbackUrl: kotlin.String?, nonce: java.math.BigDecimal?) : RequestConfig<UnnestTokenRequest> {
        val localVariableBody = unnestTokenRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (use != null) {
                    put("use", listOf(use.toString()))
                }
                if (withFee != null) {
                    put("withFee", listOf(withFee.toString()))
                }
                if (verify != null) {
                    put("verify", listOf(verify.toString()))
                }
                if (callbackUrl != null) {
                    put("callbackUrl", listOf(callbackUrl.toString()))
                }
                if (nonce != null) {
                    put("nonce", listOf(nonce.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/tokens/unnest",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
