// Code generated by gobind. DO NOT EDIT.

// Java class bindings.ChannelsFileTransfer is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * ChannelsFileTransfer manages the sending and receiving of file via channels.
Refer to [channelsFileTransfer.FileTransfer] for additional documentation.
 */
public final class ChannelsFileTransfer implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	ChannelsFileTransfer(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public ChannelsFileTransfer() { this.refnum = __New(); Seq.trackGoRef(refnum, this); }
	
	private static native int __New();
	
	/**
	 * CloseSend deletes a file from the internal storage once a transfer has
	completed or reached the retry limit. If neither of those condition are met,
	an error is returned.
	
	This function should be called once a transfer completes or errors out (as
	reported by the progress callback).
	
	Parameters:
	  - fileIDBytes - Marshalled bytes of the file&#39;s [fileTransfer.ID].
	 */
	public native void closeSend(byte[] fileIDBytes) throws Exception;
	/**
	 * Download begins the download of the file described in the marshalled
	[channelsFileTransfer.FileInfo]. The progress of the download is reported on
	the [FtReceivedProgressCallback].
	
	Once the download completes, the file will be stored in the event model with
	the given file ID and with the status [channels.ReceptionProcessingComplete].
	
	The [FtReceivedProgressCallback] only indicates the progress of the file
	download, not the status of the file in the event model. You must rely on
	updates from the event model to know when it can be retrieved.
	
	Parameters:
	  - fileInfoJSON - The JSON of [channelsFileTransfer.FileInfo] received on a
	    channel.
	  - progressCB - A callback that reports the progress of the file download.
	    The callback is called once on initialization, on every progress update
	    (or less if restricted by the period), or on fatal error.
	  - periodMS - A progress callback will be limited from triggering only once
	    per period, in milliseconds.
	
	Returns:
	  - Marshalled bytes of [fileTransfer.ID] that uniquely identifies the file.
	 */
	public native byte[] download(byte[] fileInfoJSON, FtReceivedProgressCallback progressCB, long periodMS) throws Exception;
	/**
	 * GetExtensionBuilderID returns the ID of the extension builder in the tracker.
	Pass this ID into the channel manager creator to use file transfer manager in
	conjunction with channels.
	 */
	public native long getExtensionBuilderID();
	/**
	 * MaxFileNameLen returns the max number of bytes allowed for a file name.
	 */
	public native long maxFileNameLen();
	/**
	 * MaxFileSize returns the max number of bytes allowed for a file.
	 */
	public native long maxFileSize();
	/**
	 * MaxFileTypeLen returns the max number of bytes allowed for a file type.
	 */
	public native long maxFileTypeLen();
	/**
	 * MaxPreviewSize returns the max number of bytes allowed for a file preview.
	 */
	public native long maxPreviewSize();
	/**
	 * RegisterReceivedProgressCallback allows for the registration of a callback to
	track the progress of an individual file download.
	
	The callback will be called immediately when added to report the current
	progress of the transfer. It will then call every time a file part is
	received, the transfer completes, or a fatal error occurs. It is called at
	most once every period regardless of the number of progress updates.
	
	In the event that the client is closed and resumed, this function must be
	used to re-register any callbacks previously registered.
	
	Once the download completes, the file will be stored in the event model with
	the given file ID and with the status [channelsFileTransfer.Complete].
	
	The [FtReceivedProgressCallback] only indicates the progress of the file
	download, not the status of the file in the event model. You must rely on
	updates from the event model to know when it can be retrieved.
	
	Parameters:
	  - fileIDBytes - Marshalled bytes of the file&#39;s [fileTransfer.ID].
	  - progressCB - A callback that reports the progress of the file upload. The
	    callback is called once on initialization, on every progress update (or
	    less if restricted by the period), or on fatal error.
	  - periodMS - A progress callback will be limited from triggering only once
	    per period, in milliseconds.
	 */
	public native void registerReceivedProgressCallback(byte[] fileIDBytes, FtReceivedProgressCallback progressCB, long periodMS) throws Exception;
	/**
	 * RegisterSentProgressCallback allows for the registration of a callback to
	track the progress of an individual file upload. A [FtSentProgressCallback]
	is auto-registered on [ChannelsFileTransfer.Send]; this function should be
	called when resuming clients or registering extra callbacks.
	
	The callback will be called immediately when added to report the current
	progress of the transfer. It will then call every time a file part arrives,
	the transfer completes, or a fatal error occurs. It is called at most once
	every period regardless of the number of progress updates.
	
	In the event that the client is closed and resumed, this function must be
	used to re-register any callbacks previously registered with this function or
	[ChannelsFileTransfer.Send].
	
	The [FtSentProgressCallback] only indicates the progress of the file upload,
	not the status of the file in the event model. You must rely on updates from
	the event model to know when it can be retrieved.
	
	Parameters:
	  - fileIDBytes - Marshalled bytes of the file&#39;s [fileTransfer.ID].
	  - progressCB - A callback that reports the progress of the file upload.
	    The callback is called once on initialization, on every progress
	    update (or less if restricted by the period), or on fatal error.
	  - periodMS - A progress callback will be limited from triggering only
	    once per period, in milliseconds.
	 */
	public native void registerSentProgressCallback(byte[] fileIDBytes, FtSentProgressCallback progressCB, long periodMS) throws Exception;
	/**
	 * RetryUpload retries uploading a failed file upload. Returns an error if the
	transfer has not failed.
	
	This function should be called once a transfer errors out (as reported by the
	progress callback).
	
	A new progress callback must be registered on retry. Any previously
	registered callbacks are defunct when the upload fails.
	
	Parameters:
	  - fileIDBytes - Marshalled bytes of the file&#39;s [fileTransfer.ID].
	  - progressCB - A callback that reports the progress of the file upload.
	    The callback is called once on initialization, on every progress
	    update (or less if restricted by the period), or on fatal error.
	  - periodMS - A progress callback will be limited from triggering only
	    once per period, in milliseconds.
	 */
	public native void retryUpload(byte[] fileIDBytes, FtSentProgressCallback progressCB, long periodMS) throws Exception;
	/**
	 * Send sends the specified file info to the channel. Once a file is uploaded
	via [ChannelsFileTransfer.Upload], its file info (found in the event model)
	can be sent to any channel.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID] to send the
	    file to.
	  - fileLinkJSON - JSON of [channelsFileTransfer.Link] stored in the event
	    model.
	  - fileName - Human-readable file name. Max length defined by
	    [MaxFileNameLen].
	  - fileType - Shorthand that identifies the type of file. Max length defined
	    by [MaxFileTypeLen].
	  - preview - A preview of the file data (e.g. a thumbnail). Max size defined
	    by [MaxPreviewSize].
	  - validUntilMS - The duration, in milliseconds, that the file is available
	    in the channel. For the maximum amount of time, use [ValidForever].
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. If left empty,
	    [GetDefaultCMixParams] will be used internally.
	  - pingsJSON - JSON of a list of Ed25519 public keys that will receive
	    notifications for this message. They must be in the channel and have
	    notifications enabled.
	
	Example pingsJSON:
	
		[
		  &#34;FgJMvgSsY4rrKkS/jSe+vFOJOs5qSSyOUSW7UtF9/KU=&#34;,
		  &#34;fPqcHtrJ398PAC35QyWXEU9PHzz8Z4BKQTCxSvpSygw=&#34;,
		  &#34;JnjCgh7g/+hNiI9VPKW01aRSxGOFmNulNCymy3ImXAo=&#34;
		]
	
	Returns:
	  - JSON of [ChannelSendReport].
	 */
	public native byte[] send(byte[] channelIdBytes, byte[] fileLinkJSON, String fileName, String fileType, byte[] preview, long validUntilMS, byte[] cmixParamsJSON, byte[] pingsJSON) throws Exception;
	/**
	 * Upload starts uploading the file to a new ID that can be sent to the
	specified channel when complete. To get progress information about the
	upload, a [FtSentProgressCallback] must be registered. All errors returned on
	the callback are fatal and the user must take action to either
	[ChannelsFileTransfer.RetryUpload] or [ChannelsFileTransfer.CloseSend].
	
	The file is added to the event model at the returned file ID with the status
	[channelsFileTransfer.Uploading]. Once the upload is complete, the file link
	is added to the event model with the status [channelsFileTransfer.Complete].
	
	The [FtSentProgressCallback] only indicates the progress of the file upload,
	not the status of the file in the event model. You must rely on updates from
	the event model to know when it can be retrieved.
	
	Parameters:
	  - fileData - File contents. Max size defined by
	    [ChannelsFileTransfer.MaxFileSize].
	  - retry - The number of sending retries allowed on send failure (e.g. a
	    retry of 2.0 with 6 parts means 12 total possible sends).
	  - progressCB - A callback that reports the progress of the file upload.
	    The callback is called once on initialization, on every progress
	    update (or less if restricted by the period), or on fatal error.
	  - periodMS - A progress callback will be limited from triggering only once
	    per period, in milliseconds.
	
	Returns:
	  - Marshalled bytes of [fileTransfer.ID] that uniquely identifies the file.
	 */
	public native byte[] upload(byte[] fileData, float retry, FtSentProgressCallback progressCB, long periodMS) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof ChannelsFileTransfer)) {
		    return false;
		}
		ChannelsFileTransfer that = (ChannelsFileTransfer)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("ChannelsFileTransfer").append("{");
		return b.append("}").toString();
	}
}

