// Code generated by gobind. DO NOT EDIT.

// Java class bindings.ChannelsManager is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * ChannelsManager is a bindings-layer struct that wraps a [channels.Manager]
interface.
 */
public final class ChannelsManager implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	/**
	 * NewChannelsManager creates a new [ChannelsManager] from a new private
	identity [channel.PrivateIdentity].
	
	This is for creating a manager for an identity for the first time. For
	generating a new one channel identity, use [GenerateChannelIdentity]. To
	reload this channel manager, use [LoadChannelsManager], passing in the
	storage tag retrieved by [ChannelsManager.GetStorageTag].
	
	Parameters:
	  - cmixID - ID of [Cmix] object in tracker. This can be retrieved using
	    [Cmix.GetID].
	  - privateIdentity - Bytes of a private identity ([channel.PrivateIdentity])
	    that is generated by [GenerateChannelIdentity].
	  - eventBuilder - An interface that contains a function that initialises and
	    returns the event model that is bindings-compatible.
	  - extensionBuilderIDsJSON - JSON of an array of integers of
	    [channels.ExtensionBuilder] IDs. The ID can be retrieved from an object
	    with an extension builder (e.g.,
	    [ChannelsFileTransfer.GetExtensionBuilderID]). Leave empty if not using
	    extension builders. Example: `[2,11,5]`.
	  - notificationsID - ID of [Notifications] object in tracker. This can be
	    retrieved using [Notifications.GetID].
	  - uiCallbacks - Callbacks to inform the UI about various events. The entire
	    interface can be nil, but if defined, each method must be implemented.
	 */
	public ChannelsManager(long cmixID, byte[] privateIdentity, EventModelBuilder eventBuilder, byte[] extensionBuilderIDsJSON, long notificationsID, ChannelUICallbacks uiCallbacks) {
		this.refnum = __NewChannelsManager(cmixID, privateIdentity, eventBuilder, extensionBuilderIDsJSON, notificationsID, uiCallbacks);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewChannelsManager(long cmixID, byte[] privateIdentity, EventModelBuilder eventBuilder, byte[] extensionBuilderIDsJSON, long notificationsID, ChannelUICallbacks uiCallbacks);
	
	// skipped constructor ChannelsManager.NewChannelsManagerGoEventModel with unsupported parameter or return types
	
	/**
	 * NewChannelsManagerMobile creates a new [ChannelsManager] from a new private
	identity [cryptoChannel.PrivateIdentity] backed with SqlLite for mobile use.
	
	This is for creating a manager for an identity for the first time. For
	generating a new one channel identity, use [GenerateChannelIdentity]. To
	reload this channel manager, use [LoadChannelsManager], passing in the
	storage tag retrieved by [ChannelsManager.GetStorageTag].
	
	Parameters:
	  - cmixID - ID of [Cmix] object in tracker. This can be retrieved using
	    [Cmix.GetID].
	  - privateIdentity - Bytes of a private identity ([channel.PrivateIdentity])
	    that is generated by [GenerateChannelIdentity].
	  - dbFilePath - absolute string path to the SqlLite database file
	  - extensionBuilderIDsJSON - JSON of an array of integers of
	    [channels.ExtensionBuilder] IDs. The ID can be retrieved from an object
	    with an extension builder (e.g.,
	    [ChannelsFileTransfer.GetExtensionBuilderID]). Leave empty if not using
	    extension builders. Example: `[2,11,5]`.
	  - notificationsID - ID of [Notifications] object in tracker. This can be
	    retrieved using [Notifications.GetID].
	  - uiCallbacks - Callbacks to inform the UI about various events. The entire
	    interface can be nil, but if defined, each method must be implemented.
	 */
	public ChannelsManager(long cmixID, byte[] privateIdentity, String dbFilePath, byte[] extensionBuilderIDsJSON, long notificationsID, ChannelUICallbacks uiCallbacks) {
		this.refnum = __NewChannelsManagerMobile(cmixID, privateIdentity, dbFilePath, extensionBuilderIDsJSON, notificationsID, uiCallbacks);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewChannelsManagerMobile(long cmixID, byte[] privateIdentity, String dbFilePath, byte[] extensionBuilderIDsJSON, long notificationsID, ChannelUICallbacks uiCallbacks);
	
	ChannelsManager(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	/**
	 * AreDMsEnabled returns the status of DMs for a given channel
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - DM status (bool) - true if DMs are enabled for passed in channel
	 */
	public native boolean areDMsEnabled(byte[] channelIdBytes) throws Exception;
	/**
	 * DeleteChannelAdminKey deletes the private key for the given channel.
	
	CAUTION: This will remove admin access. This cannot be undone. If the
	private key is deleted, it cannot be recovered and the channel can never
	have another admin.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void deleteChannelAdminKey(byte[] channelIdBytes) throws Exception;
	/**
	 * DeleteMessage deletes the targeted message from user&#39;s view. Users may delete
	their own messages but only the channel admin can delete other user&#39;s
	messages. If the user is not an admin of the channel or if they are not the
	sender of the targetMessage, then the error [channels.NotAnAdminErr] is
	returned.
	
	If undoAction is true, then the targeted message is un-deleted.
	
	Clients will drop the deletion if they do not recognize the target
	message.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of channel [id.ID].
	  - targetMessageIdBytes - The marshalled [channel.MessageID] of the message
	    you want to delete.
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. This may be empty, and
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] deleteMessage(byte[] channelIdBytes, byte[] targetMessageIdBytes, byte[] cmixParamsJSON) throws Exception;
	/**
	 * DeleteNickname removes the nickname for a given channel. The name will revert
	back to the codename for this channel instead.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void deleteNickname(byte[] channelIDBytes) throws Exception;
	/**
	 * DisableDirectMessages removes the token for direct messaging for a
	given channel.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void disableDirectMessages(byte[] channelIdBytes) throws Exception;
	/**
	 * EnableDirectMessages enables the token for direct messaging for this
	channel.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void enableDirectMessages(byte[] channelIdBytes) throws Exception;
	/**
	 * ExportChannelAdminKey gets the private key for the given channel ID, encrypts
	it with the provided encryptionPassword, and exports it into a portable
	format. Returns an error if the user is not an admin of the channel.
	
	This key can be provided to other users in a channel to grant them admin
	access using [ChannelsManager.ImportChannelAdminKey].
	
	The private key is encrypted using a key generated from the password using
	Argon2. Each call to ExportChannelAdminKey produces a different encrypted
	packet regardless if the same password is used for the same channel. It
	cannot be determined which channel the payload is for nor that two payloads
	are for the same channel.
	
	The passwords between each call are not related. They can be the same or
	different with no adverse impact on the security properties.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - encryptionPassword - The password used to encrypt the private key. The
	    passwords between each call are not related. They can be the same or
	    different with no adverse impact on the security properties.
	
	Returns:
	  - Portable string of the channel private key encrypted with the password.
	 */
	public native byte[] exportChannelAdminKey(byte[] channelIDBytes, String encryptionPassword) throws Exception;
	/**
	 * ExportPrivateIdentity encrypts the private identity using the password and
	exports it to a portable string.
	
	Parameters:
	  - password - The password used to encrypt the private identity.
	
	Returns:
	  - []byte - Encrypted portable private identity.
	 */
	public native byte[] exportPrivateIdentity(String password) throws Exception;
	/**
	 * GenerateChannel creates a new channel with the user as the admin and returns
	the broadcast.Channel object. This function only create a channel and does
	not join it.
	
	The private key is saved to storage and can be accessed with
	ExportChannelAdminKey.
	
	Parameters:
	  - name - The name of the new channel. The name must be between 3 and 24
	    characters inclusive. It can only include upper and lowercase Unicode
	    letters, digits 0 through 9, and underscores (_). It cannot be
	    changed once a channel is created.
	  - description - The description of a channel. The description is optional
	    but cannot be longer than 144 characters and can include all Unicode
	    characters. It cannot be changed once a channel is created.
	  - privacyLevel - The [broadcast.PrivacyLevel] of the channel. 0 = public,
	    1 = private, and 2 = secret. Refer to the comment below for more
	    information.
	
	Returns:
	  - string - The pretty print of the channel.
	
	The [broadcast.PrivacyLevel] of a channel indicates the level of channel
	information revealed when sharing it via URL. For any channel besides public
	channels, the secret information is encrypted and a password is required to
	share and join a channel.
	  - A privacy level of [broadcast.Public] reveals all the information
	    including the name, description, privacy level, public key and salt.
	  - A privacy level of [broadcast.Private] reveals only the name and
	    description.
	  - A privacy level of [broadcast.Secret] reveals nothing.
	 */
	public native String generateChannel(String name, String description, long privacyLevel) throws Exception;
	/**
	 * GetChannels returns the IDs of all channels that have been joined.
	
	Returns:
	  - []byte - A JSON marshalled array of [id.ID].
	
	JSON Example:
	
		{
		  &#34;U4x/lrFkvxuXu59LtHLon1sUhPJSCcnZND6SugndnVID&#34;,
		  &#34;15tNdkKbYXoMn58NO6VbDMDWFEyIhTWEGsvgcJsHWAgD&#34;
		}
	 */
	public native byte[] getChannels() throws Exception;
	/**
	 * GetID returns the unique tracking ID for the [ChannelsManager] object.
	 */
	public native long getID();
	/**
	 * GetIdentity returns the public identity ([channel.Identity]) of the user
	associated with this channel manager.
	
	Returns:
	  - []byte - JSON of [channel.Identity].
	 */
	public native byte[] getIdentity() throws Exception;
	/**
	 * GetMutedUsers returns the list of the public keys for each muted user in
	the channel. If there are no muted user or if the channel does not exist,
	an empty list is returned.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - []byte - JSON of an array of ed25519.PublicKey. Look below for an
	    example.
	
	Example return:
	
		[&#34;k2IrybDXjJtqxjS6Tx/6m3bXvT/4zFYOJnACNWTvESE=&#34;,&#34;ocELv7KyeCskLz4cm0klLWhmFLYvQL2FMDco79GTXYw=&#34;,&#34;mmxoDgoTEYwaRyEzq5Npa24IIs+3B5LXhll/8K5yCv0=&#34;]
	 */
	public native byte[] getMutedUsers(byte[] channelIDBytes) throws Exception;
	/**
	 * GetNickname returns the nickname set for a given channel.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - string - The nickname for the channel.
	 */
	public native String getNickname(byte[] channelIDBytes) throws Exception;
	/**
	 * GetNotificationLevel returns the [channels.NotificationLevel] for the given
	channel.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - int - The [channels.NotificationLevel] for the channel.
	 */
	public native long getNotificationLevel(byte[] channelIDBytes) throws Exception;
	/**
	 * GetNotificationStatus returns the notification status for the given channel.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - int - The [notifications.NotificationState] for the channel.
	 */
	public native long getNotificationStatus(byte[] channelIDBytes) throws Exception;
	/**
	 * GetShareURL generates a URL that can be used to share this channel with
	others on the given host.
	
	A URL comes in one of three forms based on the privacy level set when
	generating the channel. Each privacy level hides more information than the
	last with the lowest level revealing everything and the highest level
	revealing nothing. For any level above the lowest, a password is returned,
	which will be required when decoding the URL.
	
	The maxUses is the maximum number of times this URL can be used to join a
	channel. If it is set to 0, then it can be shared unlimited times. The max
	uses is set as a URL parameter using the key [broadcast.MaxUsesKey]. Note
	that this number is also encoded in the secret data for private and secret
	URLs, so if the number is changed in the URL, it will be verified when
	calling [DecodePublicURL] and [DecodePrivateURL]. There is no enforcement for
	public URLs.
	
	Parameters:
	  - cmixID - ID of [Cmix] object in tracker.
	  - host - The URL to append the channel info to.
	  - maxUses - The maximum number of uses the link can be used (0 for
	    unlimited).
	  - channelIdBytes - Marshalled bytes of the channel ([id.ID]).
	
	Returns:
	  - JSON of [ShareURL].
	 */
	public native byte[] getShareURL(long cmixID, String host, long maxUses, byte[] channelIdBytes) throws Exception;
	/**
	 * GetStorageTag returns the tag where this manager is stored. To be used when
	loading the manager. The storage tag is derived from the public key.
	 */
	public native String getStorageTag();
	/**
	 * ImportChannelAdminKey decrypts and imports the given encrypted private key
	and grants the user admin access to the channel the private key belongs to.
	Returns an error if the private key cannot be decrypted or if the private key
	is for the wrong channel.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - encryptionPassword - The password used to encrypt the private key.
	  - encryptedPrivKey - The encrypted channel private key packet.
	
	Returns:
	  - Returns the error [channels.WrongPasswordErr] for an invalid password.
	  - Returns the error [channels.ChannelDoesNotExistsErr] if the channel has
	    not already been joined.
	  - Returns the error [channels.WrongPrivateKeyErr] if the private key does
	    not belong to the channel.
	 */
	public native void importChannelAdminKey(byte[] channelIdBytes, String encryptionPassword, byte[] encryptedPrivKey) throws Exception;
	/**
	 * IsChannelAdmin returns true if the user is an admin of the channel.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - bool - True if the user is an admin in the channel and false otherwise.
	 */
	public native boolean isChannelAdmin(byte[] channelIDBytes) throws Exception;
	/**
	 * JoinChannel joins the given channel. It will return the error
	[channels.ChannelAlreadyExistsErr] if the channel has already been joined.
	
	Parameters:
	  - channelPretty - A portable channel string. Should be received from
	    another user or generated via [ChannelsManager.GenerateChannel].
	
	The pretty print will be of the format:
	
		&lt;Speakeasy-v3:Test_Channel|description:Channel description.|level:Public|created:1666718081766741100|secrets:+oHcqDbJPZaT3xD5NcdLY8OjOMtSQNKdKgLPmr7ugdU=|rCI0wr01dHFStjSFMvsBzFZClvDIrHLL5xbCOPaUOJ0=|493|1|7cBhJxVfQxWo+DypOISRpeWdQBhuQpAZtUbQHjBm8NQ=&gt;
	
	Returns:
	  - []byte - JSON of [ChannelInfo], which describes all relevant channel
	    info.
	 */
	public native byte[] joinChannel(String channelPretty) throws Exception;
	/**
	 * LeaveChannel leaves the given channel. It will return the error
	[channels.ChannelDoesNotExistsErr] if the channel was not previously joined.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void leaveChannel(byte[] channelIdBytes) throws Exception;
	/**
	 * MuteUser is used to mute a user in a channel. Muting a user will cause all
	future messages from the user being dropped on reception. Muted users are
	also unable to send messages. Only the channel admin can mute a user; if the
	user is not an admin of the channel, then the error [channels.NotAnAdminErr]
	is returned.
	
	If undoAction is true, then the targeted user will be unmuted.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of channel [id.ID].
	  - mutedUserPubKeyBytes - The [ed25519.PublicKey] of the user you want to
	    mute.
	  - undoAction - Set to true to unmute the user.
	  - validUntilMS - The time, in milliseconds, that the user should be muted.
	    To remain muted indefinitely, use [ValidForever].
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. This may be empty, and
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] muteUser(byte[] channelIdBytes, byte[] mutedUserPubKeyBytes, boolean undoAction, long validUntilMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * Muted returns true if the user is currently muted in the given channel.
	
	Parameters:
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	
	Returns:
	  - bool - True if the user is muted in the channel and false otherwise.
	 */
	public native boolean muted(byte[] channelIDBytes) throws Exception;
	/**
	 * PinMessage pins the target message to the top of a channel view for all users
	in the specified channel. Only the channel admin can pin user messages; if
	the user is not an admin of the channel, then the error
	[channels.NotAnAdminErr] is returned.
	
	If undoAction is true, then the targeted message is unpinned.
	
	Clients will drop the pin if they do not recognize the target message.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of channel [id.ID].
	  - targetMessageIdBytes - The marshalled [channel.MessageID] of the message
	    you want to pin.
	  - undoAction - Set to true to unpin the message.
	  - validUntilMS - The time, in milliseconds, that the message should be
	    pinned. To remain pinned indefinitely, use [ValidForever].
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. This may be empty, and
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] pinMessage(byte[] channelIdBytes, byte[] targetMessageIdBytes, boolean undoAction, long validUntilMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * RegisterReceiveHandler registers a listener for non-default message types so
	that they can be processed by modules. It is important that such modules
	collective up with the event model implementation.
	
	There can only be one handler per [channels.MessageType]; the error
	[channels.MessageTypeAlreadyRegistered] will be returned on multiple
	registrations of the same type.
	
	Parameters:
	  - messageType - The [channels.MessageType] that the listener listens for.
	  - listenerCb - The callback which will be executed when a channel message
	    of messageType is received.
	  - name - A name describing what type of messages the listener picks up.
	    This is used for debugging and logging.
	  - userSpace - Set to true if this listener can receive messages from normal
	    users.
	  - adminSpace - Set to true if this listener can receive messages from
	    admins.
	  - mutedSpace - Set to true if this listener can receive messages from muted
	    users.
	 */
	public native void registerReceiveHandler(long messageType, ChannelMessageReceptionCallback listenerCb, String name, boolean userSpace, boolean adminSpace, boolean mutedSpace) throws Exception;
	/**
	 * ReplayChannel replays all messages from the channel within the network&#39;s
	memory (~3 weeks) over the event model.
	
	Returns the error [channels.ChannelDoesNotExistsErr] if the channel was not
	previously joined.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void replayChannel(byte[] channelIdBytes) throws Exception;
	/**
	 * SendAdminGeneric is used to send a raw message over a channel encrypted with
	admin keys, identifying it as sent by the admin. In general, it should be
	wrapped in a function that defines the wire protocol.
	
	If the final message, before being sent over the wire, is too long, this will
	return an error. The message must be at most 510 bytes long.
	
	If the user is not an admin of the channel (i.e. does not have a private key
	for the channel saved to storage), then the error [channels.NotAnAdminErr] is
	returned.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - messageType - The message type of the message. This will be a valid
	    [channels.MessageType].
	  - message - The contents of the message. The message should be at most 510
	    bytes. This need not be of data type string, as the message could be a
	    specified format that the channel may recognize.
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - tracked - Set tracked to true if the message should be tracked in the
	    sendTracker, which allows messages to be shown locally before they are
	    received on the network. In general, all messages that will be displayed
	    to the user should be tracked while all actions should not be.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendAdminGeneric(byte[] channelIdBytes, long messageType, byte[] message, long validUntilMS, boolean tracked, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendGeneric is used to send a raw message over a channel. In general, it
	should be wrapped in a function that defines the wire protocol.
	
	If the final message, before being sent over the wire, is too long, this
	will return an error. Due to the underlying encoding using compression,
	it is not possible to define the largest payload that can be sent, but it
	will always be possible to send a payload of 802 bytes at minimum.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - messageType - The message type of the message. This will be a valid
	    [channels.MessageType].
	  - message - The contents of the message. This need not be of data type
	    string, as the message could be a specified format that the channel may
	    recognize.
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - tracked - Set tracked to true if the message should be tracked in the
	    sendTracker, which allows messages to be shown locally before they are
	    received on the network. In general, all messages that will be displayed
	    to the user should be tracked while all actions should not be.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and [GetDefaultCMixParams] will be used internally.
	  - pingsMapJSON - JSON of a map of slices of [ed25519.PublicKey] of users
	    that should receive mobile notifications for the message. Each slice keys
	    on a [channels.PingType] that describes the type of notification it is.
	
	Example pingsMapJSON:
	
		{
		  &#34;usrMention&#34;: [
		    &#34;CLdKxbe8D2WVOpx1mT63TZ5CP/nesmxHLT5DUUalpe0=&#34;,
		    &#34;S2c6NXjNqgR11SCOaiQUughWaLpWBKNufPt6cbTVHMA=&#34;
		  ],
		  &#34;usrReply&#34;: [
		    &#34;aaMzSeA6Cu2Aix2MlOwzrAI+NnpKshzvZRT02PZPVec=&#34;
		  ]
		}
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendGeneric(byte[] channelIdBytes, long messageType, byte[] message, long validUntilMS, boolean tracked, byte[] cmixParamsJSON, byte[] pingsMapJSON) throws Exception;
	/**
	 * SendInvite is used to send to a channel (invited) an invitation to another
	channel (invitee).
	
	If the channel ID for the invitee channel is not recognized by the Manager,
	then an error will be returned.
	
	The reception of an invitation will be handled by
	[EventModel.ReceiveMessage], passing in a [channels.MessageType] of
	value [channels.Invitation]. The message will be JSON encoded.
	Example invite JSON:
	
		{
		   &#34;text&#34;: &#34;Check this channel out!&#34;,
		   &#34;inviteLink&#34;: &#34;https://internet.speakeasy.tech/?0Name=name&amp;1Description=description&amp;2Level=Public&amp;3Created=1687359213751145652&amp;e=gnnLqhgsNJE7uFTLRsv1q%2FzgHBesVsezln4mg4mQZ70%3D&amp;k=aOULKJDhSkNOou7CwsybaNTrdfrUS55%2Ffv%2FuHjX2Mc4%3D&amp;l=928&amp;m=0&amp;p=1&amp;s=cN2iHg6b5FdViS4q46QMolQUF0BZt98NEiO6NKrL1d0%3D&amp;v=1&#34;,
		   &#34;password&#34;: &#34;secret&#34;
		}
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID]
	    This is invited channel.
	  - inviteToChannelJSON - A JSON marshalled channel. This should be the data
	    of the invitee channel. This can be retrieved from [GetChannelJSON].
	  - message - The contents of the message. The message should be at most 510
	    bytes. This is expected to be Unicode, and thus a string data type is
	    expected.
	  - host - The URL to append the channel info to.
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and GetDefaultCMixParams will be used internally.
	  - pingsJSON - JSON of a slice of public keys of users that should receive
	    mobile notifications for the message.
	
	Example pingsJSON:
	
		[
		  &#34;FgJMvgSsY4rrKkS/jSe+vFOJOs5qSSyOUSW7UtF9/KU=&#34;,
		  &#34;fPqcHtrJ398PAC35QyWXEU9PHzz8Z4BKQTCxSvpSygw=&#34;,
		  &#34;JnjCgh7g/+hNiI9VPKW01aRSxGOFmNulNCymy3ImXAo=&#34;
		]
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendInvite(byte[] channelIdBytes, byte[] inviteToJson, String message, String host, long validUntilMS, byte[] cmixParamsJSON, byte[] pingsJSON) throws Exception;
	/**
	 * SendMessage is used to send a formatted message over a channel.
	
	Due to the underlying encoding using compression, it isn&#39;t possible to define
	the largest payload that can be sent, but it will always be possible to send
	a payload of 798 bytes at minimum.
	
	The message will auto delete validUntil after the round it is sent in,
	lasting forever if [channels.ValidForever] is used.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - message - The contents of the message. The message should be at most 510
	    bytes. This is expected to be Unicode, and thus a string data type is
	    expected
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be
	    empty, and [GetDefaultCMixParams] will be used internally.
	  - pingsJSON - JSON of a slice of public keys of users that should receive
	    mobile notifications for the message.
	
	Example pingsJSON:
	
		[
		  &#34;FgJMvgSsY4rrKkS/jSe+vFOJOs5qSSyOUSW7UtF9/KU=&#34;,
		  &#34;fPqcHtrJ398PAC35QyWXEU9PHzz8Z4BKQTCxSvpSygw=&#34;,
		  &#34;JnjCgh7g/+hNiI9VPKW01aRSxGOFmNulNCymy3ImXAo=&#34;
		]
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendMessage(byte[] channelIdBytes, String message, long validUntilMS, byte[] cmixParamsJSON, byte[] pingsJSON) throws Exception;
	/**
	 * SendReaction is used to send a reaction to a message over a channel. The
	reaction must be a single emoji with no other characters, and will be
	rejected otherwise.
	
	Clients will drop the reaction if they do not recognize the reactTo message.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - reaction - The user&#39;s reaction. This should be a single emoji with no
	    other characters. As such, a Unicode string is expected.
	  - messageToReactTo - The marshalled [channel.MessageID] of the message you
	    wish to reply to. This may be found in the ChannelSendReport if replying
	    to your own. Alternatively, if reacting to another user&#39;s message, you
	    may retrieve it via the ChannelMessageReceptionCallback registered using
	    RegisterReceiveHandler.
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and GetDefaultCMixParams will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendReaction(byte[] channelIdBytes, String reaction, byte[] messageToReactTo, long validUntilMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendReply is used to send a formatted message over a channel.
	
	Due to the underlying encoding using compression, it is not possible to
	define the largest payload that can be sent, but it will always be possible
	to send a payload of 766 bytes at minimum.
	
	If the message ID that the reply is sent to does not exist, then the other
	side will post the message as a normal message and not as a reply.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - message - The contents of the message. The message should be at most 510
	    bytes. This is expected to be Unicode, and thus a string data type is
	    expected.
	  - messageToReactTo - The marshalled [channel.MessageID] of the message you
	    wish to reply to. This may be found in the [ChannelSendReport] if
	    replying to your own. Alternatively, if reacting to another user&#39;s
	    message, you may retrieve it via the [ChannelMessageReceptionCallback]
	    registered using [RegisterReceiveHandler].
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and [GetDefaultCMixParams] will be used internally.
	  - pingsJSON - JSON of a slice of public keys of users that should receive
	    mobile notifications for the message.
	
	Example pingsJSON:
	
		[
		  &#34;FgJMvgSsY4rrKkS/jSe+vFOJOs5qSSyOUSW7UtF9/KU=&#34;,
		  &#34;fPqcHtrJ398PAC35QyWXEU9PHzz8Z4BKQTCxSvpSygw=&#34;,
		  &#34;JnjCgh7g/+hNiI9VPKW01aRSxGOFmNulNCymy3ImXAo=&#34;
		]
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendReply(byte[] channelIdBytes, String message, byte[] messageToReactTo, long validUntilMS, byte[] cmixParamsJSON, byte[] pingsJSON) throws Exception;
	/**
	 * SendSilent is used to send to a channel a message with no notifications.
	Its primary purpose is to communicate new nicknames without calling
	[SendMessage].
	
	It takes no payload intentionally as the message should be very lightweight.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - validUntilMS - The lease of the message. This will be how long the
	    message is available from the network, in milliseconds. As per the
	    [channels.Manager] documentation, this has different meanings depending
	    on the use case. These use cases may be generic enough that they will not
	    be enumerated here. Use [channels.ValidForever] to last the max message
	    life.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - JSON of [ChannelSendReport].
	 */
	public native byte[] sendSilent(byte[] channelIdBytes, long validUntilMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SetMobileNotificationsLevel sets the notification level for the given
	channel. The [channels.NotificationLevel] dictates the type of notifications
	received and the status controls weather the notification is push or in-app.
	If muted, both the level and status must be set to mute.
	
	To use push notifications, a token must be registered with the notification
	manager. Note, when enabling push notifications, information may be shared
	with third parties (i.e., Firebase and Google&#39;s Palantir) and may represent a
	security risk to the user.
	
	Parameters:
	  - channelIDBytes - The marshaled bytes of the channel&#39;s [id.ID].
	  - level - The [channels.NotificationLevel] to set for the channel.
	  - status - The [notifications.NotificationState] to set for the channel.
	 */
	public native void setMobileNotificationsLevel(byte[] channelIDBytes, long level, long status) throws Exception;
	/**
	 * SetNickname sets the nickname for a given channel. The nickname must be valid
	according to [IsNicknameValid].
	
	Parameters:
	  - nickname - The new nickname.
	  - channelIDBytes - The marshalled bytes of the channel&#39;s [id.ID].
	 */
	public native void setNickname(String nickname, byte[] channelIDBytes) throws Exception;
	/**
	 * VerifyChannelAdminKey verifies that the encrypted private key can be
	decrypted and that it matches the expected channel. Returns false if private
	key does not belong to the given channel.
	
	Parameters:
	  - channelIdBytes - Marshalled bytes of the channel&#39;s [id.ID].
	  - encryptionPassword - The password used to encrypt the private key.
	  - encryptedPrivKey - The encrypted channel private key packet.
	
	Returns:
	  - bool - True if the private key belongs to the channel and false
	    otherwise.
	  - Returns the error [channels.WrongPasswordErr] for an invalid password.
	  - Returns the error [channels.ChannelDoesNotExistsErr] if the channel has
	    not already been joined.
	 */
	public native boolean verifyChannelAdminKey(byte[] channelIdBytes, String encryptionPassword, byte[] encryptedPrivKey) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof ChannelsManager)) {
		    return false;
		}
		ChannelsManager that = (ChannelsManager)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("ChannelsManager").append("{");
		return b.append("}").toString();
	}
}

