// Code generated by gobind. DO NOT EDIT.

// Java class bindings.Cmix is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * Cmix wraps the xxdk.Cmix struct, implementing additional functions to support
the bindings Cmix interface.
 */
public final class Cmix implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	Cmix(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public Cmix() { this.refnum = __New(); Seq.trackGoRef(refnum, this); }
	
	private static native int __New();
	
	/**
	 * AddHealthCallback adds a callback that gets called whenever the network
	health changes. Returns a registration ID that can be used to unregister.
	 */
	public native long addHealthCallback(NetworkHealthCallback nhc);
	/**
	 * ChangeNumberOfNodeRegistrations changes the number of parallel node
	registrations up to the initialized maximum.
	
	Parameters:
	  - toRun - The number of parallel node registrations.
	  - timeoutMS - The timeout, in milliseconds, to wait when changing node
	    registrations before failing.
	 */
	public native void changeNumberOfNodeRegistrations(long toRun, long timeoutMS) throws Exception;
	/**
	 * Connect performs auth key negotiation with the given recipient and returns a
	Connection object for the newly created partner.Manager.
	
	This function is to be used sender-side and will block until the
	partner.Manager is confirmed.
	
	Parameters:
	  - e2eId - ID of the E2E object in the e2e tracker
	  - recipientContact - marshalled contact.Contact object
	  - e2eParamsJSON - JSON marshalled byte of xxdk.E2EParams object
	 */
	public native Connection connect(long e2eId, byte[] recipientContact, byte[] e2eParamsJSON) throws Exception;
	public native AuthenticatedConnection connectWithAuthentication(long e2eId, byte[] recipientContact, byte[] e2eParamsJSON) throws Exception;
	/**
	 * EKVGet allows access to a value inside secure encrypted key value store
	 */
	public native byte[] ekvGet(String key) throws Exception;
	/**
	 * EKVSet allows user to set a value inside secure encrypted key value store
	 */
	public native void ekvSet(String key, byte[] value) throws Exception;
	/**
	 * GetID returns the ID for this Cmix in the cmixTracker.
	 */
	public native long getID();
	/**
	 * GetNodeRegistrationStatus returns the current state of node registration.
	
	Returns:
	  - []byte - A marshalled NodeRegistrationReport containing the number of
	    nodes the user is registered with and the number of nodes present in the
	    NDF.
	  - An error if it cannot get the node registration status. The most likely
	    cause is that the network is unhealthy.
	 */
	public native byte[] getNodeRegistrationStatus() throws Exception;
	/**
	 * GetReceptionID returns the Default Reception Identity for this cMix
	Instance
	 */
	public native byte[] getReceptionID();
	/**
	 * GetReceptionRegistrationValidationSignature returns the signature provided by
	the xx network.
	 */
	public native byte[] getReceptionRegistrationValidationSignature();
	/**
	 * GetRemoteKV returns the underlying [RemoteKV] storage so it can be
	interacted with directly.
	TODO: force this into a synchronized prefix?
	 */
	public native RemoteKV getRemoteKV();
	/**
	 * GetRunningProcesses returns the names of all running processes at the time
	of this call. Note that this list may change and is subject to race
	conditions if multiple threads are in the process of starting or stopping.
	
	Returns:
	  - []byte - A JSON marshalled list of all running processes.
	
	JSON Example:
	
		{
		  &#34;FileTransfer{BatchBuilderThread, FilePartSendingThread#0, FilePartSendingThread#1, FilePartSendingThread#2, FilePartSendingThread#3}&#34;,
		  &#34;MessageReception Worker 0&#34;
		}
	 */
	public native byte[] getRunningProcesses() throws Exception;
	/**
	 * HasRunningProcessies checks if any background threads are running and returns
	true if one or more are.
	
	This is meant to be used when NetworkFollowerStatus returns xxdk.Stopping.
	Due to the handling of comms on iOS, where the OS can block indefinitely, it
	may not enter the stopped state appropriately. This can be used instead.
	 */
	public native boolean hasRunningProcessies();
	/**
	 * IsHealthy returns true if the network is read to be in a healthy state where
	messages can be sent.
	 */
	public native boolean isHealthy();
	/**
	 * IsReady returns true if at least percentReady of node registrations has
	completed. If not all have completed, then it returns false and howClose will
	be a percent (0-1) of node registrations completed.
	
	Parameters:
	  - percentReady - The percentage of nodes required to be registered with to
	    be ready. This is a number between 0 and 1.
	
	Returns:
	  - JSON of [IsReadyInfo].
	 */
	public native byte[] isReady(double percentReady) throws Exception;
	/**
	 * MakeLegacyReceptionIdentity generates the legacy identity for receiving
	messages. As with all legacy calls, this should primarily be used
	for the xx messenger team.
	 */
	public native byte[] makeLegacyReceptionIdentity() throws Exception;
	/**
	 * MakeReceptionIdentity generates a new cryptographic identity for receiving
	messages.
	 */
	public native byte[] makeReceptionIdentity() throws Exception;
	/**
	 * NetworkFollowerStatus gets the state of the network follower. It returns a
	status with the following values:
	
		Stopped  - 0
		Running  - 2000
		Stopping - 3000
	 */
	public native long networkFollowerStatus();
	/**
	 * PauseNodeRegistrations stops all node registrations and returns a function to
	resume them.
	
	Parameters:
	  - timeoutMS - The timeout, in milliseconds, to wait when stopping threads
	    before failing.
	 */
	public native void pauseNodeRegistrations(long timeoutMS) throws Exception;
	/**
	 * ReadyToSend determines if the network is ready to send messages on. It
	returns true if the network is healthy and if the client has registered with
	at least 70% of the nodes. Returns false otherwise.
	 */
	public native boolean readyToSend();
	/**
	 * RegisterClientErrorCallback registers the callback to handle errors from the
	long-running threads controlled by StartNetworkFollower and
	StopNetworkFollower.
	 */
	public native void registerClientErrorCallback(ClientError clientError);
	/**
	 * RemoveHealthCallback removes a health callback using its registration ID.
	 */
	public native void removeHealthCallback(long funcID);
	/**
	 * SetTrackNetworkPeriod allows changing the frequency that follower threads
	are started.
	
	Note that the frequency of the follower threads affect the power usage
	of the device following the network.
	  - Low period -&gt; Higher frequency of polling -&gt; Higher battery usage
	  - High period -&gt; Lower frequency of polling -&gt; Lower battery usage
	
	This may be used to enable a low power (or battery optimization) mode
	for the end user.
	
	Suggested values are provided, however there are no guarantees that these
	values will perfectly fit what the end user&#39;s device would require to match
	the user&#39;s expectations:
	  - Low Power Usage: 5000 milliseconds
	  - High Power Usage: 1000 milliseconds (default, see
	    [cmix.DefaultFollowPeriod]
	
	Parameters:
	  - periodMS - The duration of the period, in milliseconds.
	 */
	public native void setTrackNetworkPeriod(long periodMS);
	/**
	 * StartNetworkFollower kicks off the tracking of the network. It starts long-
	running network threads and returns an object for checking state and
	stopping those threads.
	
	Call this when returning from sleep and close when going back to sleep.
	
	These threads may become a significant drain on battery when offline, ensure
	they are stopped if there is no internet access.
	
	Threads Started:
	  - Network Follower (/network/follow.go)
	    tracks the network events and hands them off to workers for handling.
	  - Historical Round Retrieval (/network/rounds/historical.go)
	    retrieves data about rounds that are too old to be stored by the client.
	  - Message Retrieval Worker Group (/network/rounds/retrieve.go)
	    requests all messages in a given round from the gateway of the last nodes.
	  - Message Handling Worker Group (/network/message/handle.go)
	    decrypts and partitions messages when signals via the Switchboard.
	  - Health Tracker (/network/health),
	    via the network instance, tracks the state of the network.
	  - Garbled Messages (/network/message/garbled.go)
	    can be signaled to check all recent messages that could be decoded. It
	    uses a message store on disk for persistence.
	  - Critical Messages (/network/message/critical.go)
	    ensures all protocol layer mandatory messages are sent. It uses a message
	    store on disk for persistence.
	  - KeyExchange Trigger (/keyExchange/trigger.go)
	    responds to sent rekeys and executes them.
	  - KeyExchange Confirm (/keyExchange/confirm.go)
	    responds to confirmations of successful rekey operations.
	  - Auth Callback (/auth/callback.go)
	    handles both auth confirm and requests.
	 */
	public native void startNetworkFollower(long timeoutMS) throws Exception;
	/**
	 * StopNetworkFollower stops the network follower if it is running. It returns
	an error if the follower is in the wrong state to stop or if it fails to stop
	it.
	
	If the network follower is running and this fails, the Cmix object will
	most likely be in an unrecoverable state and need to be trashed.
	 */
	public native void stopNetworkFollower() throws Exception;
	/**
	 * TrackServices will return, via a callback, the list of services that the
	backend keeps track of, which is formally referred to as a
	[message.ServiceList]. This may be passed into other bindings calls that
	may need context on the available services for this client. This will
	provide services for all identities that the client tracks.
	
	Parameters:
	  - cb - A [TrackServicesCallback], which will be passed the JSON of
	    [message.ServiceList].
	 */
	public native void trackServices(TrackServicesCallback cb);
	/**
	 * TrackServicesWithIdentity will return, via a callback, the list of services
	that the backend keeps track of for the provided identity. This may be passed
	into other bindings calls that may need context on the available services for
	this single identity. This will only return services for the given identity.
	
	Parameters:
	  - e2eID - ID of [E2e] object in tracker.
	  - cb - A [TrackServicesCallback], which will be passed the JSON of
	    [message.ServiceList].
	  - compressedCb - A [TrackCompressedServicesCallback], which will be passed
	    the JSON of [message.CompressedServiceList].
	 */
	public native void trackServicesWithIdentity(long e2eId, TrackServicesCallback cb, TrackCompressedServicesCallback compressedCb) throws Exception;
	/**
	 * WaitForNetwork will block until either the network is healthy or the passed
	timeout is reached. It will return true if the network is healthy.
	 */
	public native boolean waitForNetwork(long timeoutMS);
	/**
	 * WaitForRoundResult allows the caller to get notified if the rounds a message
	was sent in successfully completed. Under the hood, this uses an API that
	uses the internal round data, network historical round lookup, and waiting on
	network events to determine what has (or will) occur.
	
	This function takes the marshaled send report to ensure a memory leak does
	not occur as a result of both sides of the bindings holding a reference to
	the same pointer.
	
	Parameters:
	  - roundList - JSON marshalled bytes of RoundsList or JSON of any send report
	    that inherits a [bindings.RoundsList] object
	  - mdc - callback that adheres to the MessageDeliveryCallback interface
	  - timeoutMS - timeout when the callback will return if no state update
	    occurs, in milliseconds
	 */
	public native void waitForRoundResult(byte[] roundList, MessageDeliveryCallback mdc, long timeoutMS) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof Cmix)) {
		    return false;
		}
		Cmix that = (Cmix)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Cmix").append("{");
		return b.append("}").toString();
	}
}

