// Code generated by gobind. DO NOT EDIT.

// Java class bindings.DMClient is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * DMClient is the bindings level interface for the direct messaging client. It
implements all the [dm.Client] functions but converts from basic types that
are friendly to gomobile and Javascript WASM interfaces (e.g., []byte, int,
and string).

Users of the bindings API can create multiple DMClient objects, which are
tracked via a private singleton.
 */
public final class DMClient implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	/**
	 * NewDMClient creates a new [DMClient] from a private identity
	([codename.PrivateIdentity]), used for direct messaging.
	
	This is for instantiating a manager for an identity. For generating
	a new identity, use [codename.GenerateIdentity]. You should instantiate
	every load as there is no load function and associated state in
	this module.
	
	Parameters:
	  - cmixID - ID of [Cmix] object in tracker (int). This can be retrieved
	    using [Cmix.GetID].
	  - notificationsID - ID of [Notifications] object in tracker. This can be
	    retrieved using [Notifications.GetID].
	  - privateIdentity - Bytes of a private identity
	    ([codename.PrivateIdentity]) that is generated by
	    [codename.GenerateIdentity].
	  - receiverBuilder - An interface that contains a function that initialises
	    and returns an [EventModel] that is bindings-compatible.
	  - cbs - Callbacks is an interface that provides updates about information
	    relating to DM conversations. The interface may be nil, but if one is
	    provided, each method must be implemented.
	 */
	public DMClient(long cmixID, long notificationsID, byte[] privateIdentity, DMReceiverBuilder receiverBuilder, DmCallbacks cbs) {
		this.refnum = __NewDMClient(cmixID, notificationsID, privateIdentity, receiverBuilder, cbs);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewDMClient(long cmixID, long notificationsID, byte[] privateIdentity, DMReceiverBuilder receiverBuilder, DmCallbacks cbs);
	
	// skipped constructor DMClient.NewDMClientWithGoEventModel with unsupported parameter or return types
	
	DMClient(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	/**
	 * BlockPartner prevents receiving messages and notifications from the partner.
	
	Parameters:
	  - partnerPubKey - The partner&#39;s Ed25519 public key to block.
	 */
	public native void blockPartner(byte[] partnerPubKey);
	/**
	 * DeleteMessage sends a message to the partner to delete a message this user
	sent. Also deletes it from the local database.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - targetMessageIdBytes - The bytes of the [message.ID] of the message to
	    delete. This may be found in the [ChannelSendReport].
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and GetDefaultCMixParams will be used internally.
	 */
	public native byte[] deleteMessage(byte[] partnerPubKeyBytes, int partnerToken, byte[] targetMessageIdBytes, byte[] cmixParamsJSON) throws Exception;
	/**
	 * ExportPrivateIdentity encrypts and exports the private identity to a portable
	string.
	 */
	public native byte[] exportPrivateIdentity(String password) throws Exception;
	/**
	 * GetBlockedPartners returns all partners who are blocked by this user.
	
	Returns:
	  - []byte - JSON of of an array of [ed25519.PublicKey].
	
	Example return:
	
		[
		  &#34;TYWuCfyGBjNWDtl/Roa6f/o206yYPpuB6sX2kJZTe98=&#34;,
		  &#34;4JLRzgtW1SZ9c5pE+v0WwrGPj1t19AuU6Gg5IND5ymA=&#34;,
		  &#34;CWDqF1bnhulW2pko+zgmbDZNaKkmNtFdUgY4bTm2DhA=&#34;
		]
	 */
	public native byte[] getBlockedPartners();
	/**
	 * GetID returns the tracker ID for the DMClient object.
	 */
	public native long getID();
	/**
	 * GetIdentity returns the public identity associated with this client.
	 */
	public native byte[] getIdentity();
	/**
	 * GetNickname gets the nickname associated with this DM user.
	 */
	public native String getNickname() throws Exception;
	/**
	 * GetNotificationLevel returns the notification level for the given channel.
	
	Parameters:
	  - partnerPubKey - The partner&#39;s Ed25519 public key.
	
	Returns:
	  - int - The [dm.NotificationLevel] to set for the DM conversation.
	 */
	public native long getNotificationLevel(byte[] partnerPubKey) throws Exception;
	/**
	 * GetPublicKey returns the bytes of the public key for this client.
	 */
	public native byte[] getPublicKey();
	/**
	 * GetShareURL generates a URL that can be used to share a URL to initiate d
	direct messages with this user.
	
	Parameters:
	  - host - The URL to append the DM info to.
	
	Returns:
	  - JSON of [DMShareURL].
	 */
	public native byte[] getShareURL(String host) throws Exception;
	/**
	 * GetToken returns the DM token of this client.
	 */
	public native long getToken();
	/**
	 * IsBlocked indicates if the given partner is blocked.
	
	Parameters:
	  - partnerPubKey - The partner&#39;s Ed25519 public key to check.
	 */
	public native boolean isBlocked(byte[] partnerPubKey);
	/**
	 * Send is used to send a raw message. In general, it
	should be wrapped in a function that defines the wire protocol.
	
	If the final message, before being sent over the wire, is too long, this will
	return an error. Due to the underlying encoding using compression, it is not
	possible to define the largest payload that can be sent, but it will always
	be possible to send a payload of 802 bytes at minimum.
	
	The meaning of leaseTimeMS depends on the use case.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - messageType - The message type of the message. This will be a valid
	    [dm.MessageType].
	  - plaintext - The contents of the message. This need not be of data type
	    string, as the message could be a specified format that the channel may
	    recognize.
	  - leaseTimeMS - The lease of the message. This will be how long the message
	    is valid until, in milliseconds. As per the [channels.Manager]
	    documentation, this has different meanings depending on the use case.
	    These use cases may be generic enough that they will not be enumerated
	    here.
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. If left empty, then
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - A JSON marshalled ChannelSendReport.
	 */
	public native byte[] send(byte[] partnerPubKeyBytes, int partnerToken, long messageType, byte[] plaintext, long leaseTimeMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendInvite is used to send to a DM partner an invitation to another
	channel.
	
	The reception of an invitation will be handled by [DMReceiver.Receive],
	passing in a [dm.MessageType] of value [dm.InvitationType]. The message
	will be JSON encoded. Example invite JSON:
	
		{
		   &#34;text&#34;: &#34;Check this channel out!&#34;,
		   &#34;inviteLink&#34;: &#34;https://internet.speakeasy.tech/?0Name=name&amp;1Description=description&amp;2Level=Public&amp;3Created=1687359213751145652&amp;e=gnnLqhgsNJE7uFTLRsv1q%2FzgHBesVsezln4mg4mQZ70%3D&amp;k=aOULKJDhSkNOou7CwsybaNTrdfrUS55%2Ffv%2FuHjX2Mc4%3D&amp;l=928&amp;m=0&amp;p=1&amp;s=cN2iHg6b5FdViS4q46QMolQUF0BZt98NEiO6NKrL1d0%3D&amp;v=1&#34;,
		   &#34;password&#34;: &#34;secret&#34;
		}
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - inviteToChannelJson - A JSON marshalled channel. This should be the data
	    of the invitee channel. This can be retrieved from [GetChannelJSON].
	  - message - The contents of the message. The message should be at most 510
	    bytes. This is expected to be Unicode, and thus a string data type is
	    expected.
	  - host - The URL to append the channel info to.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and GetDefaultCMixParams will be used internally.
	 */
	public native byte[] sendInvite(byte[] partnerPubKeyBytes, int partnerToken, byte[] inviteToChannelJson, String message, String host, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendReaction is used to send a reaction to a direct message.
	The reaction must be a single emoji with no other characters,
	and will be rejected otherwise.
	
	Clients will drop the reaction if they do not recognize the reactTo message.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - reaction - The user&#39;s reaction. This should be a single emoji with no
	    other characters. As such, a Unicode string is expected.
	  - reactToBytes - The bytes of the [message.ID] of the message you wish to
	    react to. This may be found in the [ChannelSendReport] if replying to
	    your own. Alternatively, if reacting to another user&#39;s message, you may
	    retrieve it via the [ChannelMessageReceptionCallback] registered using
	    [ChannelsManager.RegisterReceiveHandler].
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. If left empty, then
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - A JSON marshalled ChannelSendReport.
	 */
	public native byte[] sendReaction(byte[] partnerPubKeyBytes, int partnerToken, String reaction, byte[] reactToBytes, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendReply is used to send a formatted direct message reply.
	
	If the message ID that the reply is sent to does not exist, then the other
	side will post the message as a normal message and not as a reply.
	
	The message will auto delete leaseTime after the round it is sent in, lasting
	forever if [ValidForever] is used.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - replyMessage - The contents of the reply message. The message should be
	    at most 510 bytes. This is expected to be Unicode, and thus a string data
	    type is expected
	  - replyToBytes - The bytes of the [message.ID] of the message you wish to
	    reply to. This may be found in the [ChannelSendReport] if replying to
	    your own. Alternatively, if reacting to another user&#39;s message, you may
	    retrieve it via the [ChannelMessageReceptionCallback] registered using
	    [ChannelsManager.RegisterReceiveHandler].
	  - leaseTimeMS - The lease of the message. This will be how long the message
	    is valid until, in milliseconds. As per the [channels.Manager]
	    documentation, this has different meanings depending on the use case.
	    These use cases may be generic enough that they will not be enumerated
	    here.
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. If left empty, then
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - A JSON marshalled ChannelSendReport
	 */
	public native byte[] sendReply(byte[] partnerPubKeyBytes, int partnerToken, String replyMessage, byte[] replyToBytes, long leaseTimeMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendSilent is used to send to a channel a message with no notifications.
	Its primary purpose is to communicate new nicknames without calling [Send].
	
	It takes no payload intentionally as the message should be very lightweight.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - cmixParamsJSON - A JSON marshalled [xxdk.CMIXParams]. This may be empty,
	    and GetDefaultCMixParams will be used internally.
	 */
	public native byte[] sendSilent(byte[] partnerPubKeyBytes, int partnerToken, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SendText is used to send a formatted direct message to a user.
	
	Parameters:
	  - partnerPubKeyBytes - The bytes of the public key of the partner&#39;s ED25519
	    signing key.
	  - partnerToken - The token used to derive the reception ID for the partner.
	  - message - The contents of the message. The message should be at most 510
	    bytes. This is expected to be Unicode, and thus a string data type is
	    expected
	  - leaseTimeMS - The lease of the message. This will be how long the message
	    is valid until, in milliseconds. As per the [channels.Manager]
	    documentation, this has different meanings depending on the use case.
	    These use cases may be generic enough that they will not be enumerated
	    here.
	  - cmixParamsJSON - JSON of [xxdk.CMIXParams]. If left empty, then
	    [GetDefaultCMixParams] will be used internally.
	
	Returns:
	  - []byte - SON of [ChannelSendReport].
	 */
	public native byte[] sendText(byte[] partnerPubKeyBytes, int partnerToken, String message, long leaseTimeMS, byte[] cmixParamsJSON) throws Exception;
	/**
	 * SetMobileNotificationsLevel sets the notification level for the given DM
	conversation partner.
	
	Parameters:
	  - partnerPubKey - The partner&#39;s Ed25519 public key.
	  - level - The [dm.NotificationLevel] to set for the DM conversation.
	 */
	public native void setMobileNotificationsLevel(byte[] partnerPubKey, long level) throws Exception;
	/**
	 * SetNickname sets the nickname to use for this user.
	 */
	public native void setNickname(String nick) throws Exception;
	/**
	 * UnblockPartner unblocks a blocked partner to allow DM messages.
	
	Parameters:
	  - partnerPubKey - The partner&#39;s Ed25519 public key to unblock.
	 */
	public native void unblockPartner(byte[] partnerPubKey);
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof DMClient)) {
		    return false;
		}
		DMClient that = (DMClient)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("DMClient").append("{");
		return b.append("}").toString();
	}
}

