// Code generated by gobind. DO NOT EDIT.

// Java class bindings.DMReceiver is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * DMReceiver is an interface which an external party which uses the dm
system passed an object which adheres to in order to get events on the
channel.
 */
public interface DMReceiver {
	/**
	 * DeleteMessage deletes the message with the given message.ID belonging to
	the sender. If the message exists and belongs to the sender, then it is
	deleted and DeleteMessage returns true. If it does not exist, it returns
	false.
	
	Parameters:
	 - messageID - The bytes of the [message.ID] of the message to delete.
	 - senderPubKey - The [ed25519.PublicKey] of the sender of the message.
	 */
	public boolean deleteMessage(byte[] messageID, byte[] senderPubKey);
	/**
	 * GetConversation returns any conversations held by the
	model (receiver). JSON List of dm.ModelConversation object.
	 */
	public byte[] getConversation(byte[] senderPubKey);
	/**
	 * GetConversations returns any conversations held by the
	model (receiver). JSON List of dm.ModelConversation object.
	 */
	public byte[] getConversations();
	/**
	 * Receive is called when a raw direct message is received
	with unkown type. It may be called multiple times on the
	same message. It is incumbent on the user of the API to
	filter such called by message ID.
	
	The api user must interpret the message type and perform
	their own message parsing.
	
	Parameters:
	 - messageID - The bytes of the [dm.MessageID] of the received
	   message.
	 - nickname - The nickname of the sender of the message.
	 - text - The bytes content of the message.
	 - timestamp - Time the message was received; represented
	   as nanoseconds since unix epoch.
	 - partnerKey - The partners&#39;s Ed25519 public key. This is
	   required to respond.
	 - senderKey - The sender&#39;s Ed25519 public key.
	 - dmToken - The senders direct messaging token. This is
	   required to respond.
	 - codeset - The codeset version.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundId - The ID of the round that the message was received on.
	 - mType - the type of the message, always 1 for this call
	 - status - the [dm.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns a non-negative unique UUID for the message that it can be
	referenced by later with [EventModel.UpdateSentStatus].
	 */
	public long receive(byte[] messageID, String nickname, byte[] text, byte[] partnerKey, byte[] senderKey, int dmToken, long codeset, long timestamp, long roundId, long mType, long status);
	/**
	 * ReceiveReaction is called whenever a reaction to a direct
	message is received. It may be called multiple times on the
	same reaction.  It is incumbent on the user of the API to
	filter such called by message ID.
	
	Messages may arrive our of order, so a reply in theory can
	arrive before the initial message. As a result, it may be
	important to buffer reactions.
	
	Parameters:
	 - messageID - The bytes of the [dm.MessageID] of the received
	   message.
	 - reactionTo - The [dm.MessageID] for the message
	   that received a reply.
	 - nickname - The nickname of the sender of the message.
	 - reaction - The contents of the reaction message.
	 - partnerKey - The partners&#39;s Ed25519 public key. This is
	   required to respond.
	 - senderKey - The sender&#39;s Ed25519 public key.
	 - dmToken - The senders direct messaging token. This is
	   required to respond.
	 - codeset - The codeset version.
	 - timestamp - Time the message was received; represented
	   as nanoseconds since unix epoch.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundId - The ID of the round that the message was received on.
	 - status - the [dm.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns a non-negative unique uuid for the message by which it can be
	referenced later with UpdateSentStatus
	 */
	public long receiveReaction(byte[] messageID, byte[] reactionTo, String nickname, String reaction, byte[] partnerKey, byte[] senderKey, int dmToken, long codeset, long timestamp, long roundId, long status);
	/**
	 * ReceiveReply is called whenever a direct message is
	received that is a reply. It may be called multiple times
	on the same message. It is incumbent on the user of the API
	to filter such called by message ID.
	
	Messages may arrive our of order, so a reply in theory can
	arrive before the initial message. As a result, it may be
	important to buffer replies.
	
	Parameters:
	 - messageID - The bytes of the [dm.MessageID] of the received
	   message.
	 - reactionTo - The [dm.MessageID] for the message
	   that received a reply.
	 - nickname - The nickname of the sender of the message.
	 - text - The content of the message.
	 - partnerKey - The partners&#39;s Ed25519 public key. This is
	   required to respond.
	 - senderKey - The sender&#39;s Ed25519 public key.
	 - dmToken - The senders direct messaging token. This is
	   required to respond.
	 - codeset - The codeset version.
	 - timestamp - Time the message was received; represented
	   as nanoseconds since unix epoch.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundId - The ID of the round that the message was received on.
	 - status - the [dm.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns a non-negative unique UUID for the message that it can be
	referenced by later with [EventModel.UpdateSentStatus].
	 */
	public long receiveReply(byte[] messageID, byte[] reactionTo, String nickname, String text, byte[] partnerKey, byte[] senderKey, int dmToken, long codeset, long timestamp, long roundId, long status);
	/**
	 * ReceiveText is called whenever a direct message is
	received that is a text type. It may be called multiple times
	on the same message. It is incumbent on the user of the API
	to filter such called by message ID.
	
	Messages may arrive our of order, so a reply in theory can
	arrive before the initial message. As a result, it may be
	important to buffer replies.
	
	Parameters:
	 - messageID - The bytes of the [dm.MessageID] of the received
	   message.
	 - nickname - The nickname of the sender of the message.
	 - text - The content of the message.
	 - partnerKey - The partners&#39;s Ed25519 public key. This is
	   required to respond.
	 - senderKey - The sender&#39;s Ed25519 public key.
	 - dmToken - The senders direct messaging token. This is
	   required to respond.
	 - codeset - The codeset version.
	 - timestamp - Time the message was received; represented
	   as nanoseconds since unix epoch.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundId - The ID of the round that the message was received on.
	 - status - the [dm.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns a non-negative unique UUID for the message that it can be
	referenced by later with [EventModel.UpdateSentStatus].
	 */
	public long receiveText(byte[] messageID, String nickname, String text, byte[] partnerKey, byte[] senderKey, int dmToken, long codeset, long timestamp, long roundId, long status);
	/**
	 * UpdateSentStatus is called whenever the sent status of a message has
	changed.
	
	Parameters:
	 - messageID - The bytes of the [dm.MessageID] of the received
	   message.
	 - status - the [dm.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	 */
	public void updateSentStatus(long uuid, byte[] messageID, long timestamp, long roundID, long status);
	
}

