// Code generated by gobind. DO NOT EDIT.

// Java class bindings.EventModel is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * EventModel is an interface which an external party which uses the channels
system passed an object which adheres to in order to get events on the
channel.
 */
public interface EventModel {
	/**
	 * DeleteMessage deletes the message with the given [channel.MessageID] from
	the database.
	
	Parameters:
	 - messageID - The bytes of the [channel.MessageID] of the message.
	 - Returns an error if the message cannot be deleted. It must return the
		  error from GetNoMessageErr if the message does not exist.
	 */
	public void deleteMessage(byte[] messageID) throws Exception;
	/**
	 * GetMessage returns the message with the given [channel.MessageID].
	
	Parameters:
	 - messageID - The bytes of the [channel.MessageID] of the message.
	
	Returns:
	 - JSON of [channels.ModelMessage].
	 - Returns an error if the message cannot be gotten. It must return the
		  error from GetNoMessageErr if the message does not exist.
	 */
	public byte[] getMessage(byte[] messageID) throws Exception;
	/**
	 * JoinChannel is called whenever a channel is joined locally.
	
	Parameters:
	 - channel - Returns the pretty print representation of a channel.
	 */
	public void joinChannel(String channel);
	/**
	 * LeaveChannel is called whenever a channel is left locally.
	
	Parameters:
	 - ChannelID - The marshalled channel [id.ID].
	 */
	public void leaveChannel(byte[] channelID);
	/**
	 * MuteUser mutes the given user or unmutes them.
	
	Parameters:
	 - channelID - The bytes of the [id.ID] of the channel the user is being
	   muted in.
	 - pubKey - The Ed25519 public key of the user that is muted or unmuted.
	 */
	public void muteUser(byte[] channelID, byte[] pubkey, boolean unmute);
	/**
	 * ReceiveMessage is called whenever a message is received on a given
	channel. It may be called multiple times on the same message. It is
	incumbent on the user of the API to filter such called by message ID.
	
	The API needs to return a UUID of the message that can be referenced at a
	later time.
	
	messageID, timestamp, and roundID are all nillable and may be updated
	based upon the UUID at a later date. A value of 0 will be passed for a
	nilled timestamp or roundID.
	
	nickname may be empty, in which case the UI is expected to display the
	codename.
	
	messageType is included in the call; it will always be [channels.Text]
	(1) for this call, but it may be required in downstream databases.
	
	Parameters:
	 - channelID - The marshalled channel [id.ID].
	 - messageID - The bytes of the [channel.MessageID] of the received
	   message.
	 - nickname - The nickname of the sender of the message.
	 - text - The content of the message.
	 - timestamp - Time the message was received; represented as nanoseconds
	   since unix epoch.
	 - pubKey - The sender&#39;s Ed25519 public key.
	 - codeset - The codeset version.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundID - The ID of the round that the message was received on.
	 - messageType - the type of the message, always 1 for this call
	 - status - the [channels.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns:
	 - int64 - A non-negative unique UUID for the message that it can be
	   referenced by later with [EventModel.UpdateFromUUID].
	 */
	public long receiveMessage(byte[] channelID, byte[] messageID, String nickname, String text, byte[] pubKey, int dmToken, long codeset, long timestamp, long lease, long roundID, long messageType, long status, boolean hidden);
	/**
	 * ReceiveReaction is called whenever a reaction to a message is received on
	a given channel. It may be called multiple times on the same reaction. It
	is incumbent on the user of the API to filter such called by message ID.
	
	Messages may arrive our of order, so a reply, in theory, can arrive
	before the initial message. As a result, it may be important to buffer
	replies.
	
	The API needs to return a UUID of the message that can be referenced at a
	later time.
	
	messageID, timestamp, and roundID are all nillable and may be updated
	based upon the UUID at a later date. A value of 0 will be passed for a
	nilled timestamp or roundID.
	
	nickname may be empty, in which case the UI is expected to display the
	codename.
	
	messageType type is included in the call; it will always be
	[channels.Text] (1) for this call, but it may be required in downstream
	databases.
	
	Parameters:
	 - channelID - The marshalled channel [id.ID].
	 - messageID - The bytes of the [channel.MessageID] of the received
	   message.
	 - reactionTo - The [channel.MessageID] for the message that received a
	   reply.
	 - nickname - The nickname of the sender of the message.
	 - reaction - The contents of the reaction message.
	 - pubKey - The sender&#39;s Ed25519 public key.
	 - codeset - The codeset version.
	 - timestamp - Time the message was received; represented as nanoseconds
	   since unix epoch.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundID - The ID of the round that the message was received on.
	 - messageType - the type of the message, always 1 for this call
	 - status - the [channels.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns:
	 - int64 - A non-negative unique UUID for the message that it can be
	   referenced by later with [EventModel.UpdateFromUUID].
	 */
	public long receiveReaction(byte[] channelID, byte[] messageID, byte[] reactionTo, String nickname, String reaction, byte[] pubKey, int dmToken, long codeset, long timestamp, long lease, long roundID, long messageType, long status, boolean hidden);
	/**
	 * ReceiveReply is called whenever a message is received that is a reply on
	a given channel. It may be called multiple times on the same message. It
	is incumbent on the user of the API to filter such called by message ID.
	
	Messages may arrive our of order, so a reply, in theory, can arrive
	before the initial message. As a result, it may be important to buffer
	replies.
	
	The API needs to return a UUID of the message that can be referenced at a
	later time.
	
	messageID, timestamp, and roundID are all nillable and may be updated
	based upon the UUID at a later date. A value of 0 will be passed for a
	nilled timestamp or roundID.
	
	nickname may be empty, in which case the UI is expected to display the
	codename.
	
	messageType type is included in the call; it will always be
	[channels.Text] (1) for this call, but it may be required in downstream
	databases.
	
	Parameters:
	 - channelID - The marshalled channel [id.ID].
	 - messageID - The bytes of the [channel.MessageID] of the received
	   message.
	 - reactionTo - The [channel.MessageID] for the message that received a
	   reply.
	 - nickname - The nickname of the sender of the message.
	 - text - The content of the message.
	 - pubKey - The sender&#39;s Ed25519 public key.
	 - codeset - The codeset version.
	 - timestamp - Time the message was received; represented as nanoseconds
	   since unix epoch.
	 - lease - The number of nanoseconds that the message is valid for.
	 - roundID - The ID of the round that the message was received on.
	 - messageType - the type of the message, always 1 for this call
	 - status - the [channels.SentStatus] of the message.
	
	Statuses will be enumerated as such:
	 Sent      =  0
	 Delivered =  1
	 Failed    =  2
	
	Returns:
	 - int64 - A non-negative unique UUID for the message that it can be
	   referenced by later with [EventModel.UpdateFromUUID].
	 */
	public long receiveReply(byte[] channelID, byte[] messageID, byte[] reactionTo, String nickname, String text, byte[] pubKey, int dmToken, long codeset, long timestamp, long lease, long roundID, long messageType, long status, boolean hidden);
	/**
	 * UpdateFromMessageID is called whenever a message with the message ID is
	modified.
	
	Timestamp, RoundID, Pinned, Hidden, and Status in the [MessageUpdateInfo]
	may be empty (as indicated by their associated boolean) and updated based
	upon the UUID at a later date.
	
	Parameters:
	 - messageID - The bytes of the [channel.MessageID] of the received
	   message.
	 - messageUpdateInfoJSON - JSON of [MessageUpdateInfo].
	
	Returns:
	 - int64 - A non-negative unique UUID for the message that it can be
	   referenced by later with [EventModel.UpdateFromUUID].
	 - Returns an error if the message cannot be updated. It must return the
		  error from GetNoMessageErr if the message does not exist.
	 */
	public long updateFromMessageID(byte[] messageID, byte[] messageUpdateInfoJSON) throws Exception;
	/**
	 * UpdateFromUUID is called whenever a message at the UUID is modified.
	
	MessageID, Timestamp, RoundID, Pinned, Hidden, and Status in the
	[MessageUpdateInfo] may be empty (as indicated by their associated
	boolean) and updated based upon the UUID at a later date.
	
	Parameters:
	 - uuid - The unique identifier of the message in the database.
	 - messageUpdateInfoJSON - JSON of [MessageUpdateInfo].
	
	Returns:
	 - Returns an error if the message cannot be updated. It must return the
		  error from GetNoMessageErr if the message does not exist.
	 */
	public void updateFromUUID(long uuid, byte[] messageUpdateInfoJSON) throws Exception;
	
}

