// Code generated by gobind. DO NOT EDIT.

// Java class bindings.FileTransfer is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * FileTransfer object is a bindings-layer struct which wraps a
[fileTransfer.FileTransfer] interface.
 */
public final class FileTransfer implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	FileTransfer(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public FileTransfer() { this.refnum = __New(); Seq.trackGoRef(refnum, this); }
	
	private static native int __New();
	
	/**
	 * CloseSend deletes a file from the internal storage once a transfer has
	completed or reached the retry limit. If neither of those condition are met,
	an error is returned.
	
	This function should be called once a transfer completes or errors out (as
	reported by the progress callback).
	
	Parameters:
	  - tidBytes - the file transfer&#39;s unique [fileTransfer.TransferID].
	 */
	public native void closeSend(byte[] tidBytes) throws Exception;
	/**
	 * MaxFileNameLen returns the max number of bytes allowed for a file name.
	 */
	public native long maxFileNameLen();
	/**
	 * MaxFileSize returns the max number of bytes allowed for a file.
	 */
	public native long maxFileSize();
	/**
	 * MaxFileTypeLen returns the max number of bytes allowed for a file type.
	 */
	public native long maxFileTypeLen();
	/**
	 * MaxPreviewSize returns the max number of bytes allowed for a file preview.
	 */
	public native long maxPreviewSize();
	/**
	 * Receive returns the full file on the completion of the transfer. It deletes
	internal references to the data and unregisters any attached progress
	callback. Returns an error if the transfer is not complete, the full file
	cannot be verified, or if the transfer cannot be found.
	
	Receive can only be called once the progress callback returns that the file
	transfer is complete.
	
	Parameters:
	  - tidBytes - The file transfer&#39;s unique [fileTransfer.TransferID].
	 */
	public native byte[] receive(byte[] tidBytes) throws Exception;
	/**
	 * RegisterReceivedProgressCallback allows for the registration of a callback to
	track the progress of an individual received file transfer.
	
	The callback will be called immediately when added to report the current
	progress of the transfer. It will then call every time a file part is
	received, the transfer completes, or a fatal error occurs. It is called at
	most once every period regardless of the number of progress updates.
	
	In the event that the client is closed and resumed, this function must be
	used to re-register any callbacks previously registered.
	
	Once the callback reports that the transfer has completed, the recipient can
	get the full file by calling Receive.
	
	Parameters:
	  - tidBytes - The file transfer&#39;s unique [fileTransfer.TransferID].
	  - callback - A callback that reports the progress of the file transfer. The
	    callback is called once on initialization, on every progress update (or
	    less if restricted by the period), or on fatal error.
	  - period - The progress callback will be limited from triggering only once
	    per period. It is a duration in milliseconds. This value should depend on
	    how frequently you want to receive updates, and should be tuned to your
	    implementation.
	 */
	public native void registerReceivedProgressCallback(byte[] tidBytes, FileTransferReceiveProgressCallback callback, long period) throws Exception;
	/**
	 * RegisterSentProgressCallback allows for the registration of a callback to
	track the progress of an individual sent file transfer.
	
	The callback will be called immediately when added to report the current
	progress of the transfer. It will then call every time a file part
	arrives, the transfer completes, or a fatal error occurs. It is called at
	most once every period regardless of the number of progress updates.
	
	In the event that the client is closed and resumed, this function must be
	used to re-register any callbacks previously registered with this
	function or Send.
	
	Parameters:
	  - tidBytes - The file transfer&#39;s unique [fileTransfer.TransferID].
	  - callback - A callback that reports the progress of the file transfer. The
	    callback is called once on initialization, on every progress update (or
	    less if restricted by the period), or on fatal error.
	  - period - The progress callback will be limited from triggering only once
	    per period. It is a duration in milliseconds. This value should depend on
	    how frequently you want to receive updates, and should be tuned to your
	    implementation.
	 */
	public native void registerSentProgressCallback(byte[] tidBytes, FileTransferSentProgressCallback callback, long period) throws Exception;
	/**
	 * Send initiates the sending of a file to a recipient and returns a transfer ID
	that uniquely identifies this file transfer. Progress for the file transfer
	is reported to that passed in callback.
	
	Parameters:
	  - payload - JSON of [FileSend], which contains the file contents and its
	    metadata.
	  - recipientID - marshalled bytes of the recipient&#39;s [id.ID].
	  - retry - The number of sending retries allowed on send failure (e.g. a
	    retry of 2.0 with 6 parts means 12 total possible sends).
	  - callback - A callback that reports the progress of the file transfer. The
	    callback is called once on initialization, on every progress update (or
	    less if restricted by the period), or on fatal error.
	  - period - The progress callback will be limited from triggering only once
	    per period. It is a duration in milliseconds. This value should depend on
	    how frequently you want to receive updates, and should be tuned to your
	    implementation.
	
	Returns:
	  - The bytes of the unique [fileTransfer.TransferID].
	 */
	public native byte[] send(byte[] payload, byte[] recipientID, float retry, FileTransferSentProgressCallback callback, long period) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof FileTransfer)) {
		    return false;
		}
		FileTransfer that = (FileTransfer)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("FileTransfer").append("{");
		return b.append("}").toString();
	}
}

