// Code generated by gobind. DO NOT EDIT.

// Java class bindings.Group is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * Group structure contains the identifying and membership information of a
group chat.
 */
public final class Group implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	Group(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public Group() { this.refnum = __New(); Seq.trackGoRef(refnum, this); }
	
	private static native int __New();
	
	/**
	 * GetCreatedMS returns the time the group was created in milliseconds. This is
	also the time the group requests were sent.
	 */
	public native long getCreatedMS();
	/**
	 * GetCreatedNano returns the time the group was created in nanoseconds. This is
	also the time the group requests were sent.
	 */
	public native long getCreatedNano();
	/**
	 * GetID return the 33-byte unique group ID. This represents the id.ID object.
	 */
	public native byte[] getID();
	/**
	 * GetInitMessage returns initial message sent with the group request.
	 */
	public native byte[] getInitMessage();
	/**
	 * GetMembership retrieves a list of group members. The list is in order;
	the first contact is the leader/creator of the group.
	All subsequent members are ordered by their ID.
	
	Returns:
	  - []byte - JSON marshalled [group.Membership], which is an array of
	    [group.Member].
	
	Example JSON [group.Membership] return:
	
		[
		  {
		    &#34;ID&#34;: &#34;U4x/lrFkvxuXu59LtHLon1sUhPJSCcnZND6SugndnVID&#34;,
		    &#34;DhKey&#34;: {
		      &#34;Value&#34;: 3534334367214237261,
		      &#34;Fingerprint&#34;: 16801541511233098363
		    }
		  },
		  {
		    &#34;ID&#34;: &#34;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD&#34;,
		    &#34;DhKey&#34;: {
		      &#34;Value&#34;: 7497468244883513247,
		      &#34;Fingerprint&#34;: 16801541511233098363
		    }
		  }
		]
	 */
	public native byte[] getMembership() throws Exception;
	/**
	 * GetName returns the name set by the user for the group.
	 */
	public native byte[] getName();
	/**
	 * Serialize serializes the Group.
	 */
	public native byte[] serialize();
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof Group)) {
		    return false;
		}
		Group that = (Group)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Group").append("{");
		return b.append("}").toString();
	}
}

