// Code generated by gobind. DO NOT EDIT.

// Java class bindings.GroupChat is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java gitlab.com/elixxir/client/v4/bindings
package bindings;

import go.Seq;

/**
 * GroupChat is a binding-layer group chat manager.
 */
public final class GroupChat implements Seq.Proxy {
	static { Bindings.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	/**
	 * NewGroupChat creates a bindings-layer group chat manager.
	
	Parameters:
	  - e2eID - e2e object ID in the tracker.
	  - requestFunc - a callback to handle group chat requests.
	  - processor - the group chat message processor.
	 */
	public GroupChat(long e2eID, GroupRequest requestFunc, GroupChatProcessor processor) {
		this.refnum = __NewGroupChat(e2eID, requestFunc, processor);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewGroupChat(long e2eID, GroupRequest requestFunc, GroupChatProcessor processor);
	
	GroupChat(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	/**
	 * GetGroup returns the group with the group ID. If no group exists, then the
	error &#34;failed to find group&#34; is returned.
	
	Parameters:
	  - groupId - The byte data representing a group ID (a byte marshalled id.ID).
	    This can be pulled from a marshalled GroupReport.
	
	Returns:
	  - Group - The bindings-layer representation of a group.
	 */
	public native Group getGroup(byte[] groupId) throws Exception;
	/**
	 * GetGroups returns a list of group IDs that the user is a member of.
	
	Returns:
	  - []byte - a JSON marshalled []*id.ID representing all group ID&#39;s.
	 */
	public native byte[] getGroups() throws Exception;
	/**
	 * JoinGroup allows a user to join a group when a request is received.
	If an error is returned, handle it properly first; you may then retry later
	with the same trackedGroupId.
	
	Parameters:
	  - serializedGroupData - the result of calling Group.Serialize() on
	    any Group object returned over the bindings
	 */
	public native void joinGroup(byte[] serializedGroupData) throws Exception;
	/**
	 * LeaveGroup deletes a group so a user no longer has access.
	
	Parameters:
	  - groupId - the byte data representing a group ID.
	    This can be pulled from a marshalled GroupReport.
	 */
	public native void leaveGroup(byte[] groupId) throws Exception;
	/**
	 * MakeGroup creates a new Group and sends a group request to all members in the
	group.
	
	Parameters:
	  - membershipBytes - the JSON marshalled list of []*id.ID; it contains the
	    IDs of members the user wants to add to the group.
	  - message - the initial message sent to all members in the group. This is an
	    optional parameter and may be nil.
	  - name - the name of the group decided by the creator. This is an optional
	    parameter and may be nil. If nil the group will be assigned the default
	    name.
	
	Returns:
	  - []byte - the JSON marshalled bytes of the GroupReport object, which can be
	    passed into Cmix.WaitForRoundResult to see if the group request message
	    send succeeded.
	 */
	public native byte[] makeGroup(byte[] membershipBytes, byte[] message, byte[] name) throws Exception;
	/**
	 * NumGroups returns the number of groups the user is a part of.
	 */
	public native long numGroups();
	/**
	 * ResendRequest resends a group request to all members in the group.
	
	Parameters:
	  - groupId - a byte representation of a group&#39;s ID.
	    This can be found in the report returned by GroupChat.MakeGroup.
	
	Returns:
	  - []byte - the JSON marshalled bytes of the GroupReport object, which can be
	    passed into WaitForRoundResult to see if the group request message send
	    succeeded.
	 */
	public native byte[] resendRequest(byte[] groupId) throws Exception;
	/**
	 * Send is the bindings-level function for sending to a group.
	
	Parameters:
	  - groupId - the byte data representing a group ID. This can be pulled from
	    marshalled GroupReport.
	  - message - the message that the user wishes to send to the group.
	  - tag - the tag associated with the message. This tag may be empty.
	
	Returns:
	  - []byte - the JSON marshalled bytes of the GroupSendReport object, which
	    can be passed into Cmix.WaitForRoundResult to see if the group message
	    send succeeded.
	 */
	public native byte[] send(byte[] groupId, byte[] message, String tag) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof GroupChat)) {
		    return false;
		}
		GroupChat that = (GroupChat)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("GroupChat").append("{");
		return b.append("}").toString();
	}
}

