/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.api;

/**
 * Representation of a Buycraft package.
 *
 * @author Connor Spencer Harries
 */
public interface BuycraftPackage {
    int getId();
    int getOrder();
    String getName();
    String getDescription();
    String getShortDescription();
    double getPrice();
    int getCategory();
    int getItemId();

    class Serialization {

        public static final String SHORT_DESCRIPTION = "shortDescription";
        public static final String DESCRIPTION = "description";
        public static final String CATEGORY = "category";
        public static final String ITEM_ID = "guiItemId";
        public static final String PRICE = "price";
        public static final String ORDER = "order";
        public static final String NAME = "name";
        public static final String ID = "id";

        Serialization() {
            throw new UnsupportedOperationException();
        }

    }
}
