/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.api;

import java.util.List;
import java.util.UUID;

/**
 * Created by Connor on 07/07/2015.
 *
 * @author Connor Spencer Harries
 */
public interface BuycraftPayment {
    long getTime();
    String getHumanTime();
    String getUsername();
    UUID getUniqueId();
    double getPrice();
    String getCurrency();
    List<Integer> getPackages();

    class Serialization {

        public static final String TIME = "time";
        public static final String HUMAN_TIME = "humanTime";
        public static final String USERNAME = "ign";
        public static final String UUID = "uuid";
        public static final String PRICE = "price";
        public static final String CURRENCY = "currency";
        public static final String PACKAGES = "packages";

        Serialization() {
            throw new UnsupportedOperationException();
        }

    }
}
