/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import ninja.smirking.buycraft.api.BuycraftCategory;

/**
 * Created by Connor on 07/07/2015.
 *
 * @author Connor Spencer Harries
 */
public class ImmutableCategory implements BuycraftCategory {
    private final int id;
    private final String name;
    private final String description;
    private final int itemId;

    ImmutableCategory(int id, String name, String description, int itemId) {
        this.description = description;
        this.itemId = itemId;
        this.name = name;
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ImmutableCategory that = (ImmutableCategory) o;

        if (id != that.id) return false;
        if (itemId != that.itemId) return false;
        if (!name.equals(that.name)) return false;
        return description.equals(that.description);

    }

    @Override
    public int hashCode() {
        int result = id;
        result = 31 * result + name.hashCode();
        result = 31 * result + description.hashCode();
        result = 31 * result + itemId;
        return result;
    }
}
