/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import java.util.HashSet;
import java.util.Set;

public class ImmutableCategoryBuilder {
    private final Set<String> setFields;

    private int id = 0;
    private String name = "";
    private String description = "";
    private int itemId = 0;

    private ImmutableCategoryBuilder() {
        this.setFields = new HashSet<>();
    }

    public ImmutableCategoryBuilder setId(int id) {
        setField("id");
        this.id = id;
        return this;
    }

    public ImmutableCategoryBuilder setName(String name) {
        setField("name");
        this.name = name;
        return this;
    }

    public ImmutableCategoryBuilder setDescription(String description) {
        setField("description");
        this.description = description;
        return this;
    }

    public ImmutableCategoryBuilder setItemId(int itemId) {
        setField("itemId");
        this.itemId = itemId;
        return this;
    }

    public ImmutableCategory build() {
        return new ImmutableCategory(id, name, description, itemId);
    }

    private void setField(String field) {
        if(setFields.contains(field)) {
            throw new IllegalStateException(String.format("Field '%s' has already been set.", field));
        }
        setFields.add(field);
    }

    public static ImmutableCategoryBuilder create() {
        return new ImmutableCategoryBuilder();
    }
}