/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import ninja.smirking.buycraft.api.BuycraftPackage;

/**
 * Created by Connor on 07/07/2015.
 *
 * @author Connor Spencer Harries
 */
public class ImmutablePackage implements BuycraftPackage {
    private final int id;
    private final int order;
    private final String name;
    private final String description;
    private final String shortDescription;
    private final double price;
    private final int category;
    private final int itemId;

    ImmutablePackage(int id, int order, String name, String description, String shortDescription, double price, int category, int itemId) {
        this.shortDescription = shortDescription;
        this.description = description;
        this.category = category;
        this.itemId = itemId;
        this.order = order;
        this.price = price;
        this.name = name;
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ImmutablePackage that = (ImmutablePackage) o;

        if (id != that.id) return false;
        if (order != that.order) return false;
        if (Double.compare(that.price, price) != 0) return false;
        if (category != that.category) return false;
        if (itemId != that.itemId) return false;
        if (!name.equals(that.name)) return false;
        if (!description.equals(that.description)) return false;
        return shortDescription.equals(that.shortDescription);

    }

    @Override
    public int hashCode() {
        int result = id;
        result = 31 * result + order;
        result = 31 * result + name.hashCode();
        result = 31 * result + description.hashCode();
        result = 31 * result + shortDescription.hashCode();
        long temp = Double.doubleToLongBits(price);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + category;
        result = 31 * result + itemId;
        return result;
    }
}
