/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import java.util.HashSet;
import java.util.Set;

public class ImmutablePackageBuilder {
    private final Set<String> setFields;

    private int id = 0;
    private int order = 0;
    private String name = "";
    private String description = "";
    private String shortDescription = "";
    private double price = 0.00;
    private int category = 0;
    private int itemId = 0;

    private ImmutablePackageBuilder() {
        this.setFields = new HashSet<>();
    }

    public ImmutablePackageBuilder setId(int id) {
        setField("id");
        this.id = id;
        return this;
    }

    public ImmutablePackageBuilder setOrder(int order) {
        setField("order");
        this.order = order;
        return this;
    }

    public ImmutablePackageBuilder setName(String name) {
        setField("name");
        this.name = name;
        return this;
    }

    public ImmutablePackageBuilder setDescription(String description) {
        setField("description");
        this.description = description;
        return this;
    }

    public ImmutablePackageBuilder setShortDescription(String shortDescription) {
        setField("shortDescription");
        this.shortDescription = shortDescription;
        return this;
    }

    public ImmutablePackageBuilder setPrice(double price) {
        setField("price");
        this.price = price;
        return this;
    }

    public ImmutablePackageBuilder setCategory(int category) {
        setField("category");
        this.category = category;
        return this;
    }

    public ImmutablePackageBuilder setItemId(int itemId) {
        setField("itemId");
        this.itemId = itemId;
        return this;
    }

    public ImmutablePackage build() {
        return new ImmutablePackage(id, order, name, description, shortDescription, price, category, itemId);
    }

    private void setField(String field) {
        if(setFields.contains(field)) {
                throw new IllegalStateException(String.format("Field '%s' has already been set.", field));
        }
        setFields.add(field);
    }

    public static ImmutablePackageBuilder create() {
        return new ImmutablePackageBuilder();
    }
}